/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice;

import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.simpleframework.xml.core.Persister;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServiceBean;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServicesBean;
import org.vhorvath.valogato.common.beans.configuration.backendservice.FeatureBean;
import org.vhorvath.valogato.common.beans.configuration.backendservice.SimulatedServiceBean;
import org.vhorvath.valogato.common.constants.ThrConstants;
import org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.IBackendServiceConfigDAO;
import org.vhorvath.valogato.common.dao.highlevel.usage.UsageDAOFactory;
import org.vhorvath.valogato.common.dao.lowlevel.cache.CacheDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.utils.ThrottlingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParentBackendServiceConfigDAO
implements IBackendServiceConfigDAO {
    @Override
    public String getBackendServicesAsXMLString() throws ThrottlingConfigurationException {
        List<BackendServiceBean> backendServiceBeans = this.getBackendServices();
        BackendServicesBean backendServicesBean = new BackendServicesBean();
        backendServicesBean.setBackendService(backendServiceBeans);
        try {
            StringWriter writer = new StringWriter();
            Persister serializer = new Persister();
            serializer.write((Object)backendServicesBean, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            throw new ThrottlingConfigurationException(e);
        }
    }

    @Override
    public FeatureBean getFeature(BackendServiceBean backendServiceBean, String simulatedServiceName) throws ThrottlingConfigurationException {
        if (simulatedServiceName == null) {
            return backendServiceBean.getFeature();
        }
        for (SimulatedServiceBean simulatedService : backendServiceBean.getSimulatedService()) {
            if (!simulatedService.getName().equals(simulatedServiceName)) continue;
            return simulatedService.getFeature();
        }
        return backendServiceBean.getFeature();
    }

    @Override
    public void loadConfig() throws ThrottlingConfigurationException {
        Persister serializer = new Persister();
        try {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("ConfigurationBackendservice.xml");
            BackendServicesBean backendServices = (BackendServicesBean)serializer.read(BackendServicesBean.class, in);
            this.processConfiguration(backendServices);
        }
        catch (ThrottlingConfigurationException tce) {
            throw tce;
        }
        catch (Exception e) {
            throw new ThrottlingConfigurationException(e);
        }
    }

    @Override
    public void loadConfig(File file) throws ThrottlingConfigurationException {
        Persister serializer = new Persister();
        try {
            BackendServicesBean backendServices = (BackendServicesBean)serializer.read(BackendServicesBean.class, file);
            this.processConfiguration(backendServices);
        }
        catch (ThrottlingConfigurationException tce) {
            throw tce;
        }
        catch (Exception e) {
            throw new ThrottlingConfigurationException(e);
        }
    }

    void processConfiguration(BackendServicesBean backendServices) throws ThrottlingConfigurationException {
        List<String> errors = this.validateBackendServices(backendServices);
        if (errors != null) {
            throw new ThrottlingConfigurationException(errors);
        }
        this.initWaitingReqFirstLastList();
        this.initFirstWaitingReqList();
        for (BackendServiceBean backendService : backendServices.getBackendService()) {
            this.put(backendService.getName(), backendService);
            UsageDAOFactory.getDAO().initBackendServiceUsage(backendService.getName());
        }
        String key = ThrottlingUtils.getWaitingReqListKey(0);
        CacheDAOFactory.getCache().put(key, Collections.synchronizedSet(new LinkedHashSet()));
    }

    private List<String> validateBackendServices(BackendServicesBean backendServices) {
        ArrayList<String> errors = new ArrayList<String>();
        for (BackendServiceBean backendService : backendServices.getBackendService()) {
            String error = this.checkInteger(backendService.getMaxLoading(), "The max loading attribute of the backend service " + backendService.getName(), 0, 99999);
            if (error != null) {
                errors.add(error);
            }
            if ((error = this.checkInteger(backendService.getAverageResponseTime(), "The average response time attribute of the backend service " + backendService.getName(), 0, 1200000)) != null) {
                errors.add(error);
            }
            if (backendService.getFeature().getParams() != null) {
                for (String key : backendService.getFeature().getParams().keySet()) {
                    String value;
                    error = this.checkParam(key, value = backendService.getFeature().getParams().get(key), String.format("The backendService(%s) / feature param(%s)", backendService.getName(), key));
                    if (error == null) continue;
                    errors.add(error);
                }
            }
            if (backendService.getSimulatedService() == null) continue;
            for (SimulatedServiceBean simulatedService : backendService.getSimulatedService()) {
                if (simulatedService.getFeature().getParams() == null) continue;
                for (String key : simulatedService.getFeature().getParams().keySet()) {
                    String value;
                    error = this.checkParam(key, value = simulatedService.getFeature().getParams().get(key), String.format("The backendService(%s) / simulatedService(%s) / param(%s)", backendService.getName(), simulatedService.getName(), key));
                    if (error == null) continue;
                    errors.add(error);
                }
            }
        }
        return errors.size() > 0 ? errors : null;
    }

    private String checkParam(String key, String value, String path) {
        StringBuffer sb = new StringBuffer();
        if (key.equals(ThrConstants.FeatureParam.period.toString())) {
            String error = this.checkInteger(value, path, 1000, 30000);
            sb.append(error == null ? "" : error);
        } else if (key.equals(ThrConstants.FeatureParam.maxNumberOfWaitingReqs.toString())) {
            String error = this.checkInteger(value, path, 50, 100000);
            sb.append(error == null ? "" : error);
        } else if (key.equals(ThrConstants.FeatureParam.waitingReqListMaxSize.toString())) {
            String error = this.checkInteger(value, path, 10, 1000);
            sb.append(error == null ? "" : error);
        } else if (key.equals(ThrConstants.FeatureParam.strategy.toString())) {
            String error = this.checkPossibleValues(value, path, ThrConstants.FeatureParamValue.fast.toString(), ThrConstants.FeatureParamValue.maintiningFreeSlots.toString(), ThrConstants.FeatureParamValue.registeringRequestsIndividually.toString());
            sb.append(error == null ? "" : error);
        } else if (key.equals(ThrConstants.FeatureParam.endpoints.toString())) {
            String error = this.checkRequired(value, path);
            sb.append(error == null ? "" : error);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    private String checkInteger(Object value, String field, int ... ranges) {
        String required = this.checkRequired(value, field);
        if (required != null) {
            return required;
        }
        try {
            Integer i = Integer.parseInt(value.toString());
            if (ranges.length == 2 && (i < ranges[0] || i > ranges[1])) {
                return String.format("%s must be in the range %s and %s.", field, Integer.toString(ranges[0]), Integer.toString(ranges[1]));
            }
        }
        catch (NumberFormatException nfe) {
            return String.format("%s must be an integer.", field);
        }
        return null;
    }

    protected String checkRequired(Object value, String field) {
        if (value == null || value.toString().length() == 0) {
            return String.format("%s is required.", field);
        }
        return null;
    }

    protected String checkPossibleValues(String value, String field, String ... values) {
        String required = this.checkRequired(value, field);
        if (required != null) {
            return required;
        }
        if (Arrays.binarySearch(values, value) < 0) {
            return String.format("The value (%s) of %s must be in the set (%s).", value, field, ThrottlingUtils.commaSeparated(values));
        }
        return null;
    }

    protected abstract void initWaitingReqFirstLastList() throws ThrottlingConfigurationException;

    protected abstract void initFirstWaitingReqList() throws ThrottlingConfigurationException;
}

