/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServiceBean;
import org.vhorvath.valogato.common.beans.configuration.backendservice.FeatureBean;
import org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.ParentBackendServiceConfigDAO;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyBackendServiceConfigDAO
extends ParentBackendServiceConfigDAO {
    private static Map<String, BackendServiceBean> backendServices = null;

    @Override
    public void put(String backendServiceName, BackendServiceBean backendServiceBean) throws ThrottlingConfigurationException {
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((backendServiceBean != null ? 1 : 0) != 0);
        if (backendServices == null) {
            backendServices = new HashMap<String, BackendServiceBean>();
        }
        backendServices.put(backendServiceName, backendServiceBean);
    }

    @Override
    public BackendServiceBean getBackendService(String backendServiceName) throws ThrottlingConfigurationException {
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        if (backendServices == null) {
            throw new ThrottlingConfigurationException(false);
        }
        return backendServices.get(backendServiceName);
    }

    @Override
    public List<BackendServiceBean> getBackendServices() throws ThrottlingConfigurationException {
        if (backendServices == null) {
            throw new ThrottlingConfigurationException(false);
        }
        return new ArrayList<BackendServiceBean>(backendServices.values());
    }

    @Override
    public Integer getMaxLoading(String backendServiceName) throws ThrottlingConfigurationException {
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        return this.getBackendService(backendServiceName).getMaxLoading();
    }

    @Override
    public FeatureBean getFeature(String backendServiceName, String simulatedServiceName) throws ThrottlingConfigurationException {
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((simulatedServiceName != null ? 1 : 0) != 0);
        BackendServiceBean backendServiceBean = this.getBackendService(backendServiceName);
        return this.getFeature(backendServiceBean, simulatedServiceName);
    }

    @Override
    public Integer getAverageResponseTime(String backendServiceName) throws ThrottlingConfigurationException {
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        return this.getBackendService(backendServiceName).getAverageResponseTime();
    }

    @Override
    protected void initWaitingReqFirstLastList() throws ThrottlingConfigurationException {
    }

    @Override
    protected void initFirstWaitingReqList() throws ThrottlingConfigurationException {
    }
}

