/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServiceBean;
import org.vhorvath.valogato.common.beans.configuration.backendservice.FeatureBean;
import org.vhorvath.valogato.common.beans.usage.WaitingReqFirstLastListBean;
import org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.ParentBackendServiceConfigDAO;
import org.vhorvath.valogato.common.dao.lowlevel.cache.CacheDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.utils.ThrottlingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryBackendServiceConfigDAO
extends ParentBackendServiceConfigDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String backendServiceName, BackendServiceBean backendServiceBean) throws ThrottlingConfigurationException {
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((backendServiceBean != null ? 1 : 0) != 0);
        LOGGER.debug(String.format("##### MemoryBackendServiceConfigDAO.put(%s, %s)", backendServiceName, backendServiceBean));
        String cacheKey = ThrottlingUtils.getConfKey(backendServiceName);
        CacheDAOFactory.getCache().lock(cacheKey);
        try {
            CacheDAOFactory.getCache().put(cacheKey, backendServiceBean);
        }
        finally {
            CacheDAOFactory.getCache().unlock(cacheKey);
        }
    }

    @Override
    public BackendServiceBean getBackendService(String backendServiceName) throws ThrottlingConfigurationException {
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        LOGGER.debug(String.format("##### MemoryBackendServiceConfigDAO.getBackendService(%s)", backendServiceName));
        BackendServiceBean backendServiceBean = CacheDAOFactory.getCache().get(ThrottlingUtils.getConfKey(backendServiceName), BackendServiceBean.class);
        if (backendServiceBean == null) {
            LOGGER.error(String.format("##### ERROR! The BackendServiceBean is null, probably the configuration is not loaded yet! backend service name = %s", backendServiceName));
            throw new ThrottlingConfigurationException(false);
        }
        return backendServiceBean;
    }

    @Override
    public List<BackendServiceBean> getBackendServices() throws ThrottlingConfigurationException {
        LOGGER.debug("##### MemoryBackendServiceConfigDAO.getBackendServices()");
        List<BackendServiceBean> backendServiceList = Collections.synchronizedList(new ArrayList());
        for (String key : CacheDAOFactory.getCache().getKeys()) {
            if (key == null || !key.toString().startsWith("CACHE_CONF_BACKEND_SERV_")) continue;
            backendServiceList.add(CacheDAOFactory.getCache().get(key.toString(), BackendServiceBean.class));
        }
        if (backendServiceList.size() == 0) {
            throw new ThrottlingConfigurationException(false);
        }
        return backendServiceList;
    }

    @Override
    public Integer getMaxLoading(String backendServiceName) throws ThrottlingConfigurationException {
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        LOGGER.debug(String.format("##### MemoryBackendServiceConfigDAO.getMaxLoading(%s)", backendServiceName));
        BackendServiceBean backendService = this.getBackendService(backendServiceName);
        return backendService.getMaxLoading();
    }

    @Override
    public FeatureBean getFeature(String backendServiceName, String simulatedServiceName) throws ThrottlingConfigurationException {
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((simulatedServiceName != null ? 1 : 0) != 0);
        LOGGER.debug(String.format("##### MemoryBackendServiceConfigDAO.getFeature(%s, %s)", backendServiceName, simulatedServiceName));
        BackendServiceBean backendServiceBean = this.getBackendService(backendServiceName);
        if (backendServiceBean == null) {
            return null;
        }
        return this.getFeature(backendServiceBean, simulatedServiceName);
    }

    @Override
    public Integer getAverageResponseTime(String backendServiceName) throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryBackendServiceConfigDAO.getAverageResponseTime(%s)", backendServiceName));
        BackendServiceBean backendService = this.getBackendService(backendServiceName);
        if (backendService == null) {
            return null;
        }
        return backendService.getAverageResponseTime();
    }

    @Override
    protected void initWaitingReqFirstLastList() throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryBackendServiceConfigDAO.initWaitingReqFirstLastList()", new Object[0]));
        WaitingReqFirstLastListBean bean = CacheDAOFactory.getCache().get(ThrottlingUtils.getWaitingReqFirstLastKey(), WaitingReqFirstLastListBean.class);
        if (bean == null) {
            bean = new WaitingReqFirstLastListBean(0, 0);
            CacheDAOFactory.getCache().put(ThrottlingUtils.getWaitingReqFirstLastKey(), bean);
        }
    }

    @Override
    protected void initFirstWaitingReqList() throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryBackendServiceConfigDAO.initFirstWaitingReqList()", new Object[0]));
        String key = ThrottlingUtils.getWaitingReqListKey(0);
        Set list = CacheDAOFactory.getCache().get(key, Set.class);
        if (list == null) {
            list = Collections.synchronizedSet(new LinkedHashSet());
            CacheDAOFactory.getCache().put(key, list);
        }
    }
}

