/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.highlevel.usage.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.vhorvath.valogato.common.beans.usage.BackendServiceFreqBean;
import org.vhorvath.valogato.common.beans.usage.BackendServiceSleepingReqBean;
import org.vhorvath.valogato.common.dao.highlevel.usage.IUsageDAO;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.exception.ThrottlingRuntimeException;
import org.vhorvath.valogato.common.utils.ThrottlingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyUsageDAO
implements IUsageDAO {
    private static Map<String, BackendServiceFreqBean> defaultUsageFreq = new Hashtable<String, BackendServiceFreqBean>();
    private static Map<String, BackendServiceSleepingReqBean> defaultUsageWaitingReq = new Hashtable<String, BackendServiceSleepingReqBean>();

    @Override
    public void setFrequency(String nameBackendService, Integer frequency) {
        BackendServiceFreqBean bean = defaultUsageFreq.get(ThrottlingUtils.getFreqKey(nameBackendService));
        if (bean == null) {
            bean = new BackendServiceFreqBean(nameBackendService, frequency);
        } else {
            bean.setFrequency(frequency);
        }
        defaultUsageFreq.put(ThrottlingUtils.getFreqKey(nameBackendService), bean);
    }

    @Override
    public void setNumberOfSleepingRequests(String nameBackendService, Integer sleepingRequests) throws ThrottlingConfigurationException {
        BackendServiceSleepingReqBean bean = defaultUsageWaitingReq.get(ThrottlingUtils.getSleepingReqKey(nameBackendService));
        if (bean == null) {
            bean = new BackendServiceSleepingReqBean(nameBackendService, sleepingRequests);
        } else {
            bean.setNumberOfSleepingRequests(sleepingRequests);
        }
        defaultUsageWaitingReq.put(ThrottlingUtils.getSleepingReqKey(nameBackendService), bean);
    }

    @Override
    public List<String> getUsageOfBackendServiceNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (BackendServiceFreqBean bean : defaultUsageFreq.values()) {
            names.add(bean.getNameBackendService());
        }
        return names;
    }

    @Override
    public void increaseNumberOfSleepingRequests(String nameBackendService) throws ThrottlingRuntimeException {
        BackendServiceSleepingReqBean bean = defaultUsageWaitingReq.get(ThrottlingUtils.getSleepingReqKey(nameBackendService));
        if (bean == null) {
            throw new ThrottlingRuntimeException(String.format("The backend service '%s' is not in the cache!", nameBackendService));
        }
        bean.setNumberOfSleepingRequests(bean.getNumberOfSleepingRequests() + 1);
        defaultUsageWaitingReq.put(nameBackendService, bean);
    }

    @Override
    public void decreaseNumberOfSleepingRequests(String nameBackendService) throws ThrottlingRuntimeException {
        BackendServiceSleepingReqBean bean = defaultUsageWaitingReq.get(ThrottlingUtils.getSleepingReqKey(nameBackendService));
        if (bean == null) {
            throw new ThrottlingRuntimeException(String.format("The backend service '%s' is not in the cache!", nameBackendService));
        }
        if (bean.getNumberOfSleepingRequests() > 0) {
            bean.setNumberOfSleepingRequests(bean.getNumberOfSleepingRequests() - 1);
            defaultUsageWaitingReq.put(nameBackendService, bean);
        }
    }

    @Override
    public void initBackendServiceUsage(String nameBackendService) throws ThrottlingConfigurationException {
        BackendServiceSleepingReqBean waitingFreqBean;
        BackendServiceFreqBean freqBean = this.getFreqOfBackendService(nameBackendService);
        if (freqBean == null) {
            defaultUsageFreq.put(ThrottlingUtils.getFreqKey(nameBackendService), new BackendServiceFreqBean(nameBackendService, 0));
        }
        if ((waitingFreqBean = this.getSleepingReqOfBackendService(nameBackendService)) == null) {
            defaultUsageWaitingReq.put(ThrottlingUtils.getSleepingReqKey(nameBackendService), new BackendServiceSleepingReqBean(nameBackendService, 0));
        }
    }

    @Override
    public List<BackendServiceFreqBean> getFreqOfBackendServices() throws ThrottlingConfigurationException {
        return new ArrayList<BackendServiceFreqBean>(defaultUsageFreq.values());
    }

    @Override
    public List<BackendServiceSleepingReqBean> getSleepingReqOfBackendServices() throws ThrottlingConfigurationException {
        return new ArrayList<BackendServiceSleepingReqBean>(defaultUsageWaitingReq.values());
    }

    @Override
    public BackendServiceFreqBean getFreqOfBackendService(String nameBackendService) throws ThrottlingConfigurationException {
        return defaultUsageFreq.get(ThrottlingUtils.getFreqKey(nameBackendService));
    }

    @Override
    public BackendServiceSleepingReqBean getSleepingReqOfBackendService(String nameBackendService) throws ThrottlingConfigurationException {
        return defaultUsageWaitingReq.get(ThrottlingUtils.getSleepingReqKey(nameBackendService));
    }

    static {
        defaultUsageFreq.put("CACHE_FREQUENCY_ICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMS", new BackendServiceFreqBean("ICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMS", 1));
        defaultUsageFreq.put("CACHE_FREQUENCY_WIFI", new BackendServiceFreqBean("WIFI", 5));
        defaultUsageFreq.put("CACHE_FREQUENCY_SPOTIFY", new BackendServiceFreqBean("SPOTIFY", 3));
        defaultUsageFreq.put("CACHE_FREQUENCY_Alma", new BackendServiceFreqBean("Alma", 1354));
        defaultUsageFreq.put("CACHE_FREQUENCY_ICOMS", new BackendServiceFreqBean("ICOMS", 535));
        defaultUsageFreq.put("CACHE_FREQUENCY_SAP", new BackendServiceFreqBean("SAP", 3345));
        defaultUsageFreq.put("CACHE_FREQUENCY_AUTO", new BackendServiceFreqBean("AUTO", 3));
        defaultUsageFreq.put("CACHE_FREQUENCY_KOCSI", new BackendServiceFreqBean("KOCSI", 242543364));
        defaultUsageFreq.put("CACHE_FREQUENCY_NEXTENT", new BackendServiceFreqBean("NEXTENT", 2342));
        defaultUsageFreq.put("CACHE_FREQUENCY_VM", new BackendServiceFreqBean("VM", 243));
        defaultUsageFreq.put("CACHE_FREQUENCY_IQS", new BackendServiceFreqBean("IQS", 23213));
        defaultUsageFreq.put("CACHE_FREQUENCY_KOZSO", new BackendServiceFreqBean("KOZSO", 5675));
        defaultUsageFreq.put("CACHE_FREQUENCY_FORMA", new BackendServiceFreqBean("FORMA", 2));
        defaultUsageFreq.put("CACHE_FREQUENCY_KOMOD", new BackendServiceFreqBean("KOMOD", 0));
        defaultUsageFreq.put("CACHE_FREQUENCY_AGY", new BackendServiceFreqBean("AGY", 23));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_ICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMS", new BackendServiceSleepingReqBean("ICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMSICOMS", 2));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_WIFI", new BackendServiceSleepingReqBean("WIFI", 0));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_SPOTIFY", new BackendServiceSleepingReqBean("SPOTIFY", 1));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_Alma", new BackendServiceSleepingReqBean("Alma", 3));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_ICOMS", new BackendServiceSleepingReqBean("ICOMS", 0));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_SAP", new BackendServiceSleepingReqBean("SAP", 2));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_AUTO", new BackendServiceSleepingReqBean("AUTO", 1));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_KOCSI", new BackendServiceSleepingReqBean("KOCSI", 0));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_NEXTENT", new BackendServiceSleepingReqBean("NEXTENT", 1));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_VM", new BackendServiceSleepingReqBean("VM", 1));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_IQS", new BackendServiceSleepingReqBean("IQS", 0));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_KOZSO", new BackendServiceSleepingReqBean("KOZSO", 4));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_FORMA", new BackendServiceSleepingReqBean("FORMA", 0));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_KOMOD", new BackendServiceSleepingReqBean("KOMOD", 0));
        defaultUsageWaitingReq.put("CACHE_NR_OF_SLEEPING_REQ_AGY", new BackendServiceSleepingReqBean("AGY", 5));
    }
}

