/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.highlevel.usage.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.beans.usage.BackendServiceFreqBean;
import org.vhorvath.valogato.common.beans.usage.BackendServiceSleepingReqBean;
import org.vhorvath.valogato.common.dao.highlevel.usage.IUsageDAO;
import org.vhorvath.valogato.common.dao.lowlevel.cache.CacheDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.exception.ThrottlingRuntimeException;
import org.vhorvath.valogato.common.utils.ThrottlingStorage;
import org.vhorvath.valogato.common.utils.ThrottlingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryUsageDAO
implements IUsageDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    @Override
    public void setFrequency(String nameBackendService, Integer frequency) throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryUsageDAO.setFrequency(%s, %s)", nameBackendService, Integer.toString(frequency)));
        BackendServiceFreqBean bean = CacheDAOFactory.getCache().get(ThrottlingUtils.getFreqKey(nameBackendService), BackendServiceFreqBean.class);
        if (bean == null) {
            throw new ThrottlingConfigurationException(String.format("The backend service %s has not been initailized when loading the backend service configuration!", nameBackendService));
        }
        bean.setFrequency(frequency);
        CacheDAOFactory.getCache().put(ThrottlingUtils.getFreqKey(nameBackendService), bean);
    }

    @Override
    public void setNumberOfSleepingRequests(String nameBackendService, Integer numberOfSleepingRequests) throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryUsageDAO.setNumberOfSleepingRequests(%s, %s)", nameBackendService, Integer.toString(numberOfSleepingRequests)));
        BackendServiceSleepingReqBean bean = CacheDAOFactory.getCache().get(ThrottlingUtils.getSleepingReqKey(nameBackendService), BackendServiceSleepingReqBean.class);
        if (bean == null) {
            throw new ThrottlingConfigurationException(String.format("The backend service %s has not been initailized when loading the backend service configuration!", nameBackendService));
        }
        bean.setNumberOfSleepingRequests(numberOfSleepingRequests);
        CacheDAOFactory.getCache().put(ThrottlingUtils.getSleepingReqKey(nameBackendService), bean);
    }

    @Override
    public List<String> getUsageOfBackendServiceNames() throws ThrottlingConfigurationException {
        LOGGER.debug("##### MemoryUsageDAO.getUsageOfBackendServiceNames()");
        List<String> usageList = Collections.synchronizedList(new ArrayList());
        for (String key : CacheDAOFactory.getCache().getKeys()) {
            if (key == null || !key.toString().startsWith("CACHE_FREQUENCY_")) continue;
            usageList.add(key.toString().substring("CACHE_FREQUENCY_".length()));
        }
        return usageList;
    }

    @Override
    public void increaseNumberOfSleepingRequests(String nameBackendService) throws ThrottlingConfigurationException, ThrottlingRuntimeException {
        BackendServiceSleepingReqBean bean = CacheDAOFactory.getCache().get(ThrottlingUtils.getSleepingReqKey(nameBackendService), BackendServiceSleepingReqBean.class);
        LOGGER.debug(String.format("##### MemoryUsageDAO.increaseNumberOfSleepingRequests(%s), increased value: %s", nameBackendService, Integer.toString(bean.getNumberOfSleepingRequests() + 1)));
        if (bean == null) {
            throw new ThrottlingConfigurationException(String.format("The backend service %s has not been initailized when loading the backend service configuration!", nameBackendService));
        }
        bean.setNumberOfSleepingRequests(bean.getNumberOfSleepingRequests() + 1);
        CacheDAOFactory.getCache().put(ThrottlingUtils.getSleepingReqKey(nameBackendService), bean);
        ThrottlingStorage.setChangedTheSleepingReqNumber(true);
    }

    @Override
    public void decreaseNumberOfSleepingRequests(String nameBackendService) throws ThrottlingConfigurationException, ThrottlingRuntimeException {
        BackendServiceSleepingReqBean bean = CacheDAOFactory.getCache().get(ThrottlingUtils.getSleepingReqKey(nameBackendService), BackendServiceSleepingReqBean.class);
        LOGGER.debug(String.format("##### MemoryUsageDAO.decreaseNumberOfSleepingRequests(%s), decreased value: %s", nameBackendService, Integer.toString(bean.getNumberOfSleepingRequests() - 1)));
        if (bean == null) {
            throw new ThrottlingConfigurationException(String.format("The backend service %s has not been initailized when loading the backend service configuration!", nameBackendService));
        }
        bean.setNumberOfSleepingRequests(bean.getNumberOfSleepingRequests() - 1);
        CacheDAOFactory.getCache().put(ThrottlingUtils.getSleepingReqKey(nameBackendService), bean);
        ThrottlingStorage.setChangedTheSleepingReqNumber(false);
    }

    @Override
    public void initBackendServiceUsage(String nameBackendService) throws ThrottlingConfigurationException {
        BackendServiceSleepingReqBean beanSleepingReq;
        LOGGER.debug(String.format("##### MemoryUsageDAO.initBackendServiceUsage(%s)", nameBackendService));
        BackendServiceFreqBean beanFreq = this.getFreqOfBackendService(nameBackendService);
        if (beanFreq == null) {
            CacheDAOFactory.getCache().put(ThrottlingUtils.getFreqKey(nameBackendService), new BackendServiceFreqBean(nameBackendService, 0));
        }
        if ((beanSleepingReq = this.getSleepingReqOfBackendService(nameBackendService)) == null) {
            CacheDAOFactory.getCache().put(ThrottlingUtils.getSleepingReqKey(nameBackendService), new BackendServiceSleepingReqBean(nameBackendService, 0));
        }
    }

    @Override
    public List<BackendServiceFreqBean> getFreqOfBackendServices() throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryUsageDAO.getFreqOfBackendServices()", new Object[0]));
        List<BackendServiceFreqBean> usageList = Collections.synchronizedList(new ArrayList());
        for (String key : CacheDAOFactory.getCache().getKeys()) {
            if (key == null || !key.toString().startsWith("CACHE_FREQUENCY_")) continue;
            usageList.add(CacheDAOFactory.getCache().get(key.toString(), BackendServiceFreqBean.class));
        }
        return usageList;
    }

    @Override
    public List<BackendServiceSleepingReqBean> getSleepingReqOfBackendServices() throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryUsageDAO.getSleepingReqOfBackendServices()", new Object[0]));
        List<BackendServiceSleepingReqBean> usageList = Collections.synchronizedList(new ArrayList());
        List<String> keys = CacheDAOFactory.getCache().getKeys();
        for (String key : keys) {
            if (key == null || !key.toString().startsWith("CACHE_NR_OF_SLEEPING_REQ_")) continue;
            usageList.add(CacheDAOFactory.getCache().get(key.toString(), BackendServiceSleepingReqBean.class));
        }
        return usageList;
    }

    @Override
    public BackendServiceFreqBean getFreqOfBackendService(String nameBackendService) throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryUsageDAO.getFreqOfBackendService(%s)", nameBackendService));
        return CacheDAOFactory.getCache().get(ThrottlingUtils.getFreqKey(nameBackendService), BackendServiceFreqBean.class);
    }

    @Override
    public BackendServiceSleepingReqBean getSleepingReqOfBackendService(String nameBackendService) throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryUsageDAO.getSleepingReqOfBackendService(%s)", nameBackendService));
        return CacheDAOFactory.getCache().get(ThrottlingUtils.getSleepingReqKey(nameBackendService), BackendServiceSleepingReqBean.class);
    }
}

