/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.highlevel.waitingreq;

import org.vhorvath.valogato.common.dao.highlevel.waitingreq.IWaitingReqDAO;
import org.vhorvath.valogato.common.dao.highlevel.waitingreq.impl.DummyWaitingReqDAO;
import org.vhorvath.valogato.common.dao.highlevel.waitingreq.impl.MemoryWaitingReqDAO;
import org.vhorvath.valogato.common.dao.lowlevel.configuration.general.GeneralConfigurationUtils;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.utils.ThrottlingStorage;

public final class WaitingReqDAOFactory {
    private WaitingReqDAOFactory() {
    }

    public static synchronized IWaitingReqDAO getDAO() throws ThrottlingConfigurationException {
        IWaitingReqDAO result = ThrottlingStorage.getWaitingReqDAOInstance();
        if (result == null) {
            String source = GeneralConfigurationUtils.getStatisticsSource();
            if (source.equals("CACHE")) {
                result = new MemoryWaitingReqDAO();
            } else if (source.equals("DUMMY")) {
                result = new DummyWaitingReqDAO();
            } else {
                throw new ThrottlingConfigurationException(String.format("Uknown statisticsSource value in the configfuration! source=%s", source));
            }
            ThrottlingStorage.setWaitingReqDAOInstance(result);
        }
        return result;
    }
}

