/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.highlevel.waitingreq.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServiceBean;
import org.vhorvath.valogato.common.beans.usage.WaitingReqFirstLastListBean;
import org.vhorvath.valogato.common.constants.ThrConstants;
import org.vhorvath.valogato.common.dao.highlevel.waitingreq.IWaitingReqDAO;
import org.vhorvath.valogato.common.dao.lowlevel.cache.CacheDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.feature.FeatureParamGetter;
import org.vhorvath.valogato.common.utils.ThrottlingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryWaitingReqDAO
implements IWaitingReqDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean registerRequest(String requestId, BackendServiceBean backendServiceBean, String simulatedServiceName, Integer waitingReqListMaxSize, Integer maxNumberOfWaitingReqs) throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryWaitingReqDAO.registerRequest(%s, %s, %s)", requestId, Integer.toString(waitingReqListMaxSize), Integer.toString(maxNumberOfWaitingReqs)));
        String key = null;
        CacheDAOFactory.getCache().lock(ThrottlingUtils.getWaitingReqFirstLastKey());
        try {
            WaitingReqFirstLastListBean firstLastBean = CacheDAOFactory.getCache().get(ThrottlingUtils.getWaitingReqFirstLastKey(), WaitingReqFirstLastListBean.class);
            this.searchingAndCleaning(null, backendServiceBean, simulatedServiceName, firstLastBean);
            key = ThrottlingUtils.getWaitingReqListKey(firstLastBean.getLast());
            Set<String> list = CacheDAOFactory.getCache().get(key, Set.class);
            if (list == null) {
                list = Collections.synchronizedSet(new LinkedHashSet());
            }
            if (list.size() < waitingReqListMaxSize) {
                list.add(requestId);
                CacheDAOFactory.getCache().put(key, list);
            } else {
                if (this.getNumberOfElementsInLists(firstLastBean, waitingReqListMaxSize, maxNumberOfWaitingReqs) >= maxNumberOfWaitingReqs) {
                    boolean bl = false;
                    return bl;
                }
                Integer nextListNumber = this.getNextListNumber(firstLastBean.getLast(), waitingReqListMaxSize, maxNumberOfWaitingReqs);
                key = ThrottlingUtils.getWaitingReqListKey(nextListNumber);
                list = Collections.synchronizedSet(new LinkedHashSet());
                list.add(requestId);
                CacheDAOFactory.getCache().put(key, list);
                firstLastBean.setLast(nextListNumber);
                CacheDAOFactory.getCache().put(ThrottlingUtils.getWaitingReqFirstLastKey(), firstLastBean);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            CacheDAOFactory.getCache().unlock(ThrottlingUtils.getWaitingReqFirstLastKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRequestNextWaiting(String requestId, BackendServiceBean backendServiceBean, String simulatedServiceName) throws ThrottlingConfigurationException {
        String strategy = FeatureParamGetter.getStrategy(backendServiceBean, simulatedServiceName);
        if (strategy != null && strategy.length() > 0 && !strategy.equals(ThrConstants.FeatureParamValue.registeringRequestsIndividually.toString())) {
            return true;
        }
        LOGGER.debug(String.format("##### MemoryWaitingReqDAO.isRequestNextWaiting(%s, %s, %s)", requestId, backendServiceBean, simulatedServiceName));
        CacheDAOFactory.getCache().lock(ThrottlingUtils.getWaitingReqFirstLastKey());
        try {
            WaitingReqFirstLastListBean firstLastBean = CacheDAOFactory.getCache().get(ThrottlingUtils.getWaitingReqFirstLastKey(), WaitingReqFirstLastListBean.class);
            boolean bl = this.searchingAndCleaning(requestId, backendServiceBean, simulatedServiceName, firstLastBean);
            return bl;
        }
        finally {
            CacheDAOFactory.getCache().unlock(ThrottlingUtils.getWaitingReqFirstLastKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterRequest(String requestId, Integer waitingReqListMaxSize, Integer maxNumberOfWaitingReqs) throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("##### MemoryWaitingReqDAO.unregisterRequest(%s, %s, %s)", requestId, Integer.toString(waitingReqListMaxSize), Integer.toString(maxNumberOfWaitingReqs)));
        String key = null;
        CacheDAOFactory.getCache().lock(ThrottlingUtils.getWaitingReqFirstLastKey());
        try {
            WaitingReqFirstLastListBean bean = CacheDAOFactory.getCache().get(ThrottlingUtils.getWaitingReqFirstLastKey(), WaitingReqFirstLastListBean.class);
            key = ThrottlingUtils.getWaitingReqListKey(bean.getFirst());
            Set list = CacheDAOFactory.getCache().get(key, Set.class);
            this.removeRequestIdFromList(requestId, list, bean, key, waitingReqListMaxSize, maxNumberOfWaitingReqs, false);
        }
        finally {
            CacheDAOFactory.getCache().unlock(ThrottlingUtils.getWaitingReqFirstLastKey());
        }
    }

    private Integer getNextListNumber(Integer listCounter, Integer waitingReqListMaxSize, Integer maxNumberOfWaitingReqs) {
        if (listCounter * waitingReqListMaxSize > maxNumberOfWaitingReqs) {
            return 0;
        }
        return listCounter + 1;
    }

    private Integer getNumberOfElementsInLists(WaitingReqFirstLastListBean bean, Integer waitingReqListMaxSize, int maxNumberOfWaitingReqs) throws ThrottlingConfigurationException {
        int numberOfElementsInLists = 0;
        if (bean.getLast() >= bean.getFirst()) {
            if (bean.getLast() - bean.getFirst() >= 2) {
                numberOfElementsInLists = (bean.getLast() - bean.getFirst() - 1) * waitingReqListMaxSize;
            }
        } else {
            int maxInd = maxNumberOfWaitingReqs / waitingReqListMaxSize + 1;
            numberOfElementsInLists = (maxInd - bean.getFirst()) * waitingReqListMaxSize + bean.getLast() * waitingReqListMaxSize;
        }
        String key = ThrottlingUtils.getWaitingReqListKey(bean.getFirst());
        numberOfElementsInLists += CacheDAOFactory.getCache().get(key, Set.class).size();
        if (bean.getLast() != bean.getFirst()) {
            key = ThrottlingUtils.getWaitingReqListKey(bean.getLast());
            numberOfElementsInLists += CacheDAOFactory.getCache().get(key, Set.class).size();
        }
        LOGGER.trace(String.format("##### MemoryWaitingReqDAO.getNumberOfElementsInLists(..): WaitingReqFirstLastListBean:%s, waitingReqListMaxSize: %s, numberOfElementsInLists: %s, key: %s", bean, waitingReqListMaxSize, numberOfElementsInLists, key));
        return numberOfElementsInLists;
    }

    private boolean searchingAndCleaning(String requestId, BackendServiceBean backendServiceBean, String simulatedServiceName, WaitingReqFirstLastListBean firstLastBean) throws ThrottlingConfigurationException {
        boolean isItTheNextOne = false;
        boolean needExamination = true;
        long actualNano = System.nanoTime();
        int inactivationLimit = backendServiceBean.getAverageResponseTime() + 2 * FeatureParamGetter.getPeriod(backendServiceBean, simulatedServiceName);
        String key = ThrottlingUtils.getWaitingReqListKey(firstLastBean.getFirst());
        Set<String> list = CacheDAOFactory.getCache().get(key, Set.class);
        if (list.size() == 0) {
            return true;
        }
        Iterator<Object> iterator = list.iterator();
        while (needExamination) {
            if (!iterator.hasNext()) {
                needExamination = false;
                continue;
            }
            String reqIdInFront = (String)iterator.next();
            if (requestId != null && reqIdInFront.equals(requestId)) {
                needExamination = false;
                isItTheNextOne = true;
                continue;
            }
            long reqNano = this.getNano(reqIdInFront);
            if ((actualNano - reqNano) / 1000000L > (long)inactivationLimit) {
                Integer waitingReqListMaxSize = FeatureParamGetter.getWaitingReqListMaxSize(backendServiceBean, simulatedServiceName);
                Integer maxNumberOfWaitingReqs = FeatureParamGetter.getMaxNumberOfWaitingReqs(backendServiceBean, simulatedServiceName);
                Map<String, Set<String>> result = this.removeRequestIdFromList(reqIdInFront, list, firstLastBean, key, waitingReqListMaxSize, maxNumberOfWaitingReqs, true);
                key = result.keySet().iterator().next();
                list = result.get(key);
                iterator = list.iterator();
                continue;
            }
            needExamination = false;
        }
        return isItTheNextOne;
    }

    private long getNano(String requestId) throws ThrottlingConfigurationException {
        int lastIndex = requestId.lastIndexOf(62);
        if (lastIndex == -1) {
            throw new ThrottlingConfigurationException(String.format("The requestId is invalid, it doesn't contain the character '>'! reqestId = %s", requestId));
        }
        try {
            return Long.valueOf(requestId.substring(lastIndex + 1));
        }
        catch (NumberFormatException e) {
            throw new ThrottlingConfigurationException(String.format("The value in requestId is not a timestamp!! value = %s", requestId.substring(lastIndex)));
        }
    }

    private Map<String, Set<String>> removeRequestIdFromList(String requestId, Set<String> list, WaitingReqFirstLastListBean bean, String key, Integer waitingReqListMaxSize, Integer maxNumberOfWaitingReqs, boolean needListBack) throws ThrottlingConfigurationException {
        String modifiableKey = key;
        Set modifiableList = list;
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put(modifiableKey, modifiableList);
        modifiableList.remove(requestId);
        if (modifiableList.size() == 0) {
            if (bean.getFirst() != 0) {
                CacheDAOFactory.getCache().remove(modifiableKey);
            } else {
                CacheDAOFactory.getCache().put(modifiableKey, Collections.synchronizedSet(new LinkedHashSet()));
            }
            Integer nextListNumber = bean.getFirst();
            if (bean.getFirst().intValue() != bean.getLast().intValue()) {
                nextListNumber = this.getNextListNumber(bean.getFirst(), waitingReqListMaxSize, maxNumberOfWaitingReqs);
                bean.setFirst(nextListNumber);
                CacheDAOFactory.getCache().put(ThrottlingUtils.getWaitingReqFirstLastKey(), bean);
            }
            if (needListBack) {
                modifiableKey = ThrottlingUtils.getWaitingReqListKey(nextListNumber);
                modifiableList = CacheDAOFactory.getCache().get(modifiableKey, Set.class);
                result = new HashMap();
                result.put(modifiableKey, modifiableList);
            }
        } else {
            CacheDAOFactory.getCache().put(modifiableKey, modifiableList);
        }
        return result;
    }
}

