/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.lowlevel.cache.impl;

import com.google.gson.Gson;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.dao.lowlevel.cache.ICache;
import org.vhorvath.valogato.common.dao.lowlevel.configuration.general.GeneralConfigurationUtils;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.utils.AbstractStoredCache;
import org.vhorvath.valogato.common.utils.ThrottlingStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoherenceCache
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    @Override
    public void lock(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### CoherenceCache.lock(%s)...", key));
        this.getCache().lock((Object)key, -1L);
        LOGGER.trace(String.format("####### Getting the CoherenceCache.lock(%s) was successful!", key));
    }

    @Override
    public void unlock(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### CoherenceCache.unlock(%s)", key));
        try {
            this.getCache().unlock((Object)key);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("####### The Coherence lock cannot be released! key = %s, reason = %s", key, "" + e));
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public <T> T get(String key, Class<T> type) throws ThrottlingConfigurationException {
        Object object;
        Object cacheValue;
        Object value;
        block5: {
            value = null;
            cacheValue = this.getCache().get((Object)key);
            if (cacheValue != null) break block5;
            T t = null;
            {
                catch (Throwable throwable) {
                    LOGGER.trace(String.format("####### CoherenceCache.get(%s, %s) = %s", key, type, value));
                    throw throwable;
                }
            }
            LOGGER.trace(String.format("####### CoherenceCache.get(%s, %s) = %s", key, type, value));
            return t;
        }
        try {
            Gson gson = new Gson();
            object = value = gson.fromJson(cacheValue.toString(), type);
        }
        catch (ClassCastException cce) {
            throw new ThrottlingConfigurationException(String.format("The type of the element '%s' is not %s! it was: %s", key, type, cacheValue.getClass()), cce);
        }
        LOGGER.trace(String.format("####### CoherenceCache.get(%s, %s) = %s", key, type, value));
        return (T)object;
    }

    @Override
    public void put(String key, Object value) throws ThrottlingConfigurationException {
        Gson gson = new Gson();
        String jsonString = gson.toJson(value);
        LOGGER.trace(String.format("####### CoherenceCache.put(%s, %s)", key, jsonString));
        this.getCache().put((Object)key, (Object)jsonString);
    }

    @Override
    public List<String> getKeys() throws ThrottlingConfigurationException {
        LOGGER.trace("####### CoherenceCache.getKeys()");
        ArrayList<String> keys = new ArrayList<String>();
        Iterator iterator = this.getCache().keySet().iterator();
        while (iterator.hasNext()) {
            keys.add((String)iterator.next());
        }
        return keys;
    }

    @Override
    public void remove(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### TerracottaCache.remove(%s)", key));
        this.getCache().remove((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NamedCache getCache() throws ThrottlingConfigurationException {
        if (ThrottlingStorage.getCache() != null) return (NamedCache)ThrottlingStorage.getCache().getCache();
        String cacheName = GeneralConfigurationUtils.getCache().getParams().get("distributedCacheName");
        if (cacheName == null) {
            throw new ThrottlingConfigurationException("The param distributedCacheName is not defined for the Coherence cache in ConfigurationGeneral.xml! e.g. <cache type=\"Coherence\"><param name=\"distributedCacheName\">THROTTLING_DISTRIBUTED_STORE</param></cache>");
        }
        Class<CacheFactory> clazz = CacheFactory.class;
        synchronized (CacheFactory.class) {
            CacheFactory.ensureCluster();
            NamedCache cache = CacheFactory.getCache((String)cacheName);
            AbstractStoredCache storedCache = new AbstractStoredCache(){

                public void shutdown() {
                }
            };
            storedCache.setCache(cache);
            ThrottlingStorage.setCache(storedCache);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (NamedCache)ThrottlingStorage.getCache().getCache();
        }
    }
}

