/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.lowlevel.cache.impl;

import com.google.gson.Gson;
import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.ClientConfigBuilder;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Instance;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.dao.lowlevel.cache.ICache;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.utils.AbstractStoredCache;
import org.vhorvath.valogato.common.utils.ThrottlingStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastCache
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    @Override
    public void lock(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### HazelcastCache.lock(%s)...", key));
        this.getHazelcastInstance().getLock((Object)key).lock();
        LOGGER.trace(String.format("####### Getting the HazelcastCache.lock(%s) was successful!", key));
    }

    @Override
    public void unlock(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### HazelcastCache.unlock(%s)", key));
        try {
            this.getHazelcastInstance().getLock((Object)key).forceUnlock();
        }
        catch (Exception e) {
            LOGGER.warn(String.format("####### The HazelcastCache lock cannot be released! key = %s, reason = %s", key, "" + e));
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public <T> T get(String key, Class<T> type) throws ThrottlingConfigurationException {
        Object object;
        IMap map;
        Object value;
        block5: {
            value = null;
            map = this.getHazelcastInstance().getMap(key);
            if (map != null && map.get("value") != null) break block5;
            T t = null;
            {
                catch (Throwable throwable) {
                    LOGGER.trace(String.format("####### HazelcastCache.get(%s, %s) = %s", key, type, value));
                    throw throwable;
                }
            }
            LOGGER.trace(String.format("####### HazelcastCache.get(%s, %s) = %s", key, type, value));
            return t;
        }
        try {
            Gson gson = new Gson();
            object = value = gson.fromJson((String)map.get("value"), type);
        }
        catch (ClassCastException cce) {
            throw new ThrottlingConfigurationException(String.format("The type of the element '%s' is not %s!", key, type), cce);
        }
        LOGGER.trace(String.format("####### HazelcastCache.get(%s, %s) = %s", key, type, value));
        return (T)object;
    }

    @Override
    public void put(String key, Object value) throws ThrottlingConfigurationException {
        Gson gson = new Gson();
        String jsonString = gson.toJson(value);
        LOGGER.trace(String.format("####### HazelcastCache.put(%s, %s)", key, jsonString));
        IMap map = this.getHazelcastInstance().getMap(key);
        map.put("value", jsonString);
    }

    @Override
    public List<String> getKeys() throws ThrottlingConfigurationException {
        LOGGER.trace("####### HazelcastCache.getKeys()");
        ArrayList<String> keys = new ArrayList<String>();
        for (Instance instance : this.getHazelcastInstance().getInstances()) {
            if (!instance.getInstanceType().isMap()) continue;
            String id = instance.getId().toString();
            if (id.contains(":")) {
                keys.add(id.substring(id.indexOf(":") + 1));
                continue;
            }
            keys.add(instance.getId().toString());
        }
        LOGGER.trace("####### keys=" + keys);
        return keys;
    }

    @Override
    public void remove(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### HazelcastCache.remove(%s)", key));
        this.getHazelcastInstance().getMap(key).destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized HazelcastClient getHazelcastInstance() throws ThrottlingConfigurationException {
        if (ThrottlingStorage.getCache() != null) return (HazelcastClient)ThrottlingStorage.getCache().getCache();
        Class<ClientConfigBuilder> clazz = ClientConfigBuilder.class;
        synchronized (ClientConfigBuilder.class) {
            ClientConfigBuilder builder = null;
            try {
                builder = new ClientConfigBuilder("hazelcast-client.properties");
            }
            catch (IOException e) {
                throw new ThrottlingConfigurationException(String.format("The file %s cannot be found!", "hazelcast-client.properties"), e);
            }
            ClientConfig clientConfig = builder.build();
            final HazelcastClient hazelcastClient = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
            AbstractStoredCache storedCache = new AbstractStoredCache(){

                public void shutdown() {
                    hazelcastClient.shutdown();
                }
            };
            storedCache.setCache(hazelcastClient);
            ThrottlingStorage.setCache(storedCache);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (HazelcastClient)ThrottlingStorage.getCache().getCache();
        }
    }
}

