/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.lowlevel.cache.impl;

import com.google.gson.Gson;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.dao.lowlevel.cache.ICache;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCache
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");
    private static final String LOCAL_CACHE_NAME = "LOCAL_THROTTLING_DISTRIBUTED_STORE";

    @Override
    public void lock(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### LocalCache.lock(%s)...", key));
        this.getCache().acquireWriteLockOnKey((Object)key);
        LOGGER.trace(String.format("####### Getting the LocalCache.lock(%s) was successful!", key));
    }

    @Override
    public void unlock(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### LocalCache.unlock(%s)", key));
        try {
            this.getCache().releaseWriteLockOnKey((Object)key);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("####### The LocalCache lock cannot be released! key = %s, reason = %s", key, "" + e));
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public <T> T get(String key, Class<T> type) throws ThrottlingConfigurationException {
        Object object;
        Element element;
        Object value;
        block5: {
            value = null;
            element = this.getCache().get((Serializable)((Object)key));
            if (element != null) break block5;
            T t = null;
            {
                catch (Throwable throwable) {
                    LOGGER.trace(String.format("####### LocalCache.get(%s, %s) = %s", key, type, value));
                    throw throwable;
                }
            }
            LOGGER.trace(String.format("####### LocalCache.get(%s, %s) = %s", key, type, value));
            return t;
        }
        try {
            Gson gson = new Gson();
            object = value = gson.fromJson((String)element.getObjectValue(), type);
        }
        catch (ClassCastException cce) {
            throw new ThrottlingConfigurationException(String.format("The type of the element '%s' is not %s! it was: %s", key, type, element.getObjectValue().getClass()), cce);
        }
        LOGGER.trace(String.format("####### LocalCache.get(%s, %s) = %s", key, type, value));
        return (T)object;
    }

    @Override
    public void put(String key, Object value) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### LocalCache.put(%s, %s)", key, value));
        Gson gson = new Gson();
        String jsonString = gson.toJson(value);
        this.getCache().put(new Element((Serializable)((Object)key), (Serializable)((Object)jsonString)));
    }

    @Override
    public List<String> getKeys() throws ThrottlingConfigurationException {
        LOGGER.trace("####### LocalCache.getKeys()");
        List keys = this.getCache().getKeys();
        LOGGER.trace("####### keys=" + keys);
        return keys;
    }

    @Override
    public void remove(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### LocalCache.remove(%s)", key));
        this.getCache().remove((Serializable)((Object)key));
    }

    private Cache getCache() throws ThrottlingConfigurationException {
        URL url = this.getClass().getResource("/valogato_local_ehcache.xml");
        CacheManager manager = CacheManager.create((URL)url);
        Cache cache = manager.getCache(LOCAL_CACHE_NAME);
        return cache;
    }
}

