/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.lowlevel.cache.impl;

import com.google.gson.Gson;
import com.whalin.MemCached.MemCachedClient;
import com.whalin.MemCached.SockIOPool;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.dao.lowlevel.cache.ICache;
import org.vhorvath.valogato.common.dao.lowlevel.configuration.general.GeneralConfigurationUtils;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.utils.AbstractStoredCache;
import org.vhorvath.valogato.common.utils.ThrottlingStorage;
import org.vhorvath.valogato.common.utils.ThrottlingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemcachedCache
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");
    private static final String LOCK_PREFIX = "THROTTLING_8erqD4c_LOCK_";

    @Override
    public void lock(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### MemcachedCache.lock(%s)...", key));
        MemCachedClient client = this.getMemcachedInstance();
        while (!client.add(LOCK_PREFIX + key, (Object)(LOCK_PREFIX + key))) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                LOGGER.trace(String.format("####### MemcachedCache.lock(%s)...", key), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        LOGGER.trace(String.format("####### Getting the MemcachedCache.lock(%s) was successful!", key));
    }

    @Override
    public void unlock(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### MemcachedCache.unlock(%s)", key));
        try {
            MemCachedClient client = this.getMemcachedInstance();
            client.delete(LOCK_PREFIX + key);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("####### The MemcachedCache lock cannot be released! key = %s, reason = %s", key, "" + e));
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public <T> T get(String key, Class<T> type) throws ThrottlingConfigurationException {
        Object object;
        String json;
        Object value;
        block5: {
            value = null;
            json = (String)this.getMemcachedInstance().get(key);
            if (json != null) break block5;
            T t = null;
            {
                catch (Throwable throwable) {
                    LOGGER.trace(String.format("####### MemcachedCache.get(%s, %s) = %s", key, type, value));
                    throw throwable;
                }
            }
            LOGGER.trace(String.format("####### MemcachedCache.get(%s, %s) = %s", key, type, value));
            return t;
        }
        try {
            Gson gson = new Gson();
            object = value = gson.fromJson(json, type);
        }
        catch (ClassCastException cce) {
            throw new ThrottlingConfigurationException(String.format("The type of the element '%s' is not %s! The json value is: %s", key, type, json), cce);
        }
        LOGGER.trace(String.format("####### MemcachedCache.get(%s, %s) = %s", key, type, value));
        return (T)object;
    }

    @Override
    public void put(String key, Object value) throws ThrottlingConfigurationException {
        Gson gson = new Gson();
        String jsonString = gson.toJson(value);
        LOGGER.trace(String.format("####### MemcachedCache.put(%s, %s)", key, jsonString));
        this.getMemcachedInstance().set(key, (Object)jsonString);
    }

    @Override
    public List<String> getKeys() throws ThrottlingConfigurationException {
        LOGGER.trace("####### MemcachedCache.getKeys()");
        ArrayList<String> keys = new ArrayList<String>();
        MemCachedClient client = this.getMemcachedInstance();
        Map items = client.statsItems();
        Iterator itemsKeysIterator = items.keySet().iterator();
        HashSet itemNumberDetailsSet = new HashSet();
        while (itemsKeysIterator.hasNext()) {
            String server = (String)itemsKeysIterator.next();
            itemNumberDetailsSet.addAll(((Map)items.get(server)).keySet());
        }
        HashSet<String> itemNumbersSet = new HashSet<String>();
        for (String noText : itemNumberDetailsSet) {
            itemNumbersSet.add(noText.split(":")[1]);
        }
        for (String itemNumberText : itemNumbersSet) {
            Map cacheDumps = client.statsCacheDump(Integer.parseInt(itemNumberText), 999999);
            for (String server : cacheDumps.keySet()) {
                Map keysInOneServer = (Map)cacheDumps.get(server);
                keys.addAll(keysInOneServer.keySet());
            }
        }
        LOGGER.trace("####### keys=" + keys);
        return keys;
    }

    @Override
    public void remove(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### MemcachedCache.remove(%s)", key));
        this.getMemcachedInstance().delete(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private MemCachedClient getMemcachedInstance() throws ThrottlingConfigurationException {
        if (ThrottlingStorage.getCache() == null) {
            Class<AbstractStoredCache> clazz = AbstractStoredCache.class;
            // MONITORENTER : org.vhorvath.valogato.common.utils.AbstractStoredCache.class
            AbstractStoredCache storedCache = new AbstractStoredCache(){

                public void shutdown() {
                }
            };
            storedCache.setCache(new MemCachedClient("Throttling_pool"));
            ThrottlingStorage.setCache(storedCache);
            // MONITOREXIT : clazz
        }
        MemCachedClient client = (MemCachedClient)ThrottlingStorage.getCache().getCache();
        this.checkServersStatuses(client);
        return client;
    }

    private void checkServersStatuses(MemCachedClient client) throws ThrottlingConfigurationException {
        Map status = client.statsSlabs();
        String[] servers = ThrottlingUtils.get(GeneralConfigurationUtils.getCache().getParams().get("servers"), String[].class);
        boolean oneServerRunning = false;
        ArrayList<String> notRunningServers = new ArrayList<String>();
        for (int i = 0; i < servers.length; ++i) {
            if (status.get(servers[i]) == null) {
                notRunningServers.add(servers[i]);
                continue;
            }
            oneServerRunning = true;
        }
        if (!oneServerRunning) {
            throw new RuntimeException("None of the memcached servers is running! Defined servers:" + ThrottlingUtils.commaSeparated(notRunningServers.toArray(new String[0])));
        }
        if (notRunningServers.size() > 0) {
            LOGGER.warn("Warning! Some of the defined Memcached servers is not running: " + ThrottlingUtils.commaSeparated(notRunningServers.toArray(new String[0])));
        }
    }

    private static int getHashingAlg(String hashingAlgText) throws ThrottlingConfigurationException {
        if (hashingAlgText == null) {
            return 3;
        }
        if (hashingAlgText.equals("CONSISTENT_HASH")) {
            return 3;
        }
        if (hashingAlgText.equals("OLD_COMPAT_HASH")) {
            return 1;
        }
        if (hashingAlgText.equals("NEW_COMPAT_HASH")) {
            return 2;
        }
        if (hashingAlgText.equals("NATIVE_HASH")) {
            return 0;
        }
        throw new ThrottlingConfigurationException(String.format("Incorert hashingAlg text in the configuration file! The correct values: %s, %s, %s, %s", 0, 1, 2, 3));
    }

    static {
        try {
            LOGGER.info("Initialization of SockIOPool is starting...");
            SockIOPool pool = SockIOPool.getInstance((String)"Throttling_pool");
            pool.setServers(ThrottlingUtils.get(GeneralConfigurationUtils.getCache().getParams().get("servers"), String[].class));
            pool.setHashingAlg(MemcachedCache.getHashingAlg(GeneralConfigurationUtils.getCache().getParams().get("hashingAlg")));
            pool.setFailover(ThrottlingUtils.get(GeneralConfigurationUtils.getCache().getParams().get("failover"), Boolean.class).booleanValue());
            pool.setInitConn(ThrottlingUtils.get(GeneralConfigurationUtils.getCache().getParams().get("initConn"), Integer.class).intValue());
            pool.setMinConn(ThrottlingUtils.get(GeneralConfigurationUtils.getCache().getParams().get("minConn"), Integer.class).intValue());
            pool.setMaxConn(ThrottlingUtils.get(GeneralConfigurationUtils.getCache().getParams().get("maxConn"), Integer.class).intValue());
            pool.setMaintSleep((long)ThrottlingUtils.get(GeneralConfigurationUtils.getCache().getParams().get("maintSleep"), Integer.class).intValue());
            pool.setSocketTO(ThrottlingUtils.get(GeneralConfigurationUtils.getCache().getParams().get("socketTO"), Integer.class).intValue());
            pool.setAliveCheck(ThrottlingUtils.get(GeneralConfigurationUtils.getCache().getParams().get("aliveCheck"), Boolean.class).booleanValue());
            pool.initialize();
        }
        catch (Exception e) {
            LOGGER.error("Initialization of SockIOPool was not successful!", (Throwable)e);
        }
    }
}

