/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.lowlevel.cache.impl;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.dao.lowlevel.cache.ICache;
import org.vhorvath.valogato.common.dao.lowlevel.configuration.general.GeneralConfigurationUtils;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerracottaCache
implements ICache {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    @Override
    public void lock(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### TerracottaCache.lock(%s)...", key));
        this.getCache().acquireWriteLockOnKey((Object)key);
        LOGGER.trace(String.format("####### Getting the TerracottaCache.lock(%s) was successful!", key));
    }

    @Override
    public void unlock(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### TerracottaCache.unlock(%s)", key));
        try {
            this.getCache().releaseWriteLockOnKey((Object)key);
        }
        catch (Exception e) {
            LOGGER.warn(String.format("####### The Terracotta lock cannot be released! key = %s, reason = %s", key, "" + e));
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public <T> T get(String key, Class<T> type) throws ThrottlingConfigurationException {
        Object object;
        Element element;
        Object value;
        block5: {
            value = null;
            element = this.getCache().get((Serializable)((Object)key));
            if (element != null) break block5;
            T t = null;
            {
                catch (Throwable throwable) {
                    LOGGER.trace(String.format("####### TerracottaCache.get(%s, %s) = %s", key, type, value));
                    throw throwable;
                }
            }
            LOGGER.trace(String.format("####### TerracottaCache.get(%s, %s) = %s", key, type, value));
            return t;
        }
        try {
            Gson gson = new Gson();
            object = value = gson.fromJson((String)element.getObjectValue(), type);
        }
        catch (ClassCastException cce) {
            throw new ThrottlingConfigurationException(String.format("The type of the element '%s' is not %s! it was: %s", key, type, element.getObjectValue().getClass()), cce);
        }
        LOGGER.trace(String.format("####### TerracottaCache.get(%s, %s) = %s", key, type, value));
        return (T)object;
    }

    @Override
    public void put(String key, Object value) throws ThrottlingConfigurationException {
        Gson gson = new Gson();
        String jsonString = gson.toJson(value);
        LOGGER.trace(String.format("####### TerracottaCache.put(%s, %s)", key, jsonString));
        this.getCache().put(new Element((Serializable)((Object)key), (Serializable)((Object)jsonString)));
    }

    @Override
    public List<String> getKeys() throws ThrottlingConfigurationException {
        LOGGER.trace("####### TerracottaCache.getKeys()");
        List keys = this.getCache().getKeys();
        LOGGER.trace("####### keys=" + keys);
        return keys;
    }

    @Override
    public void remove(String key) throws ThrottlingConfigurationException {
        LOGGER.trace(String.format("####### TerracottaCache.remove(%s)", key));
        this.getCache().remove((Serializable)((Object)key));
    }

    private Cache getCache() throws ThrottlingConfigurationException {
        CacheManager manager = CacheManager.create();
        String cacheName = GeneralConfigurationUtils.getCache().getParams().get("distributedCacheName");
        if (cacheName == null) {
            throw new ThrottlingConfigurationException("The param distributedCacheName is not defined for the Terracotta cache in ConfigurationGeneral.xml! e.g. <cache type=\"Terracotta\"><param name=\"distributedCacheName\">THROTTLING_DISTRIBUTED_STORE</param></cache>");
        }
        Cache cache = manager.getCache(cacheName);
        return cache;
    }
}

