/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.dao.lowlevel.configuration.general;

import java.io.InputStream;
import java.util.List;
import org.simpleframework.xml.core.Persister;
import org.vhorvath.valogato.common.beans.configuration.general.CacheBean;
import org.vhorvath.valogato.common.beans.configuration.general.GeneralConfigurationBean;
import org.vhorvath.valogato.common.beans.configuration.general.NewFeatureBean;
import org.vhorvath.valogato.common.constants.ThrConstants;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneralConfigurationUtils {
    private static GeneralConfigurationBean generalConfiguration = null;
    private static final Object MONITOR = new Object();

    private GeneralConfigurationUtils() {
    }

    public static List<NewFeatureBean> getFeatures() throws ThrottlingConfigurationException {
        GeneralConfigurationUtils.init();
        return generalConfiguration.getNewFeature();
    }

    public static String getBackendserviceConfigSource() throws ThrottlingConfigurationException {
        GeneralConfigurationUtils.init();
        String backendserviceConfigSource = generalConfiguration.getBackendserviceConfigSource();
        if (backendserviceConfigSource != null && backendserviceConfigSource.trim().length() > 0 && (backendserviceConfigSource.equals(ThrConstants.Source.cache.toString()) || backendserviceConfigSource.equals(ThrConstants.Source.dummy.toString()))) {
            return backendserviceConfigSource;
        }
        throw new ThrottlingConfigurationException(String.format("The source of the backendservice config file (e.g. <backendserviceConfigSource>DUMMY</backendserviceConfigSource>) contains an invalid value! invalid value:'%s'", backendserviceConfigSource));
    }

    public static String getStatisticsSource() throws ThrottlingConfigurationException {
        GeneralConfigurationUtils.init();
        String statisticsSource = generalConfiguration.getStatisticsSource();
        if (statisticsSource != null && statisticsSource.trim().length() > 0 && (statisticsSource.equals(ThrConstants.Source.cache.toString()) || statisticsSource.equals(ThrConstants.Source.dummy.toString()))) {
            return statisticsSource;
        }
        throw new ThrottlingConfigurationException(String.format("The source of the statisticsSource (e.g. <statisticsSource>DUMMY</statisticsSource>) contains an invalid value! invalid value:'%s'", statisticsSource));
    }

    public static CacheBean getCache() throws ThrottlingConfigurationException {
        GeneralConfigurationUtils.init();
        CacheBean cache = generalConfiguration.getCache();
        if (cache != null) {
            return cache;
        }
        throw new ThrottlingConfigurationException("The element cache (e.g. <cache type=\"...\">...</cache>) cannot be found in the general configuration XML file!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() throws ThrottlingConfigurationException {
        if (generalConfiguration == null) {
            Object object = MONITOR;
            synchronized (object) {
                if (generalConfiguration == null) {
                    Persister serializer = new Persister();
                    try {
                        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("ConfigurationGeneral.xml");
                        if (in == null) {
                            throw new ThrottlingConfigurationException(String.format("The general configuration XML cannot be read! path=%s", "ConfigurationGeneral.xml"));
                        }
                        generalConfiguration = (GeneralConfigurationBean)serializer.read(GeneralConfigurationBean.class, in);
                    }
                    catch (ThrottlingConfigurationException tce) {
                        throw tce;
                    }
                    catch (Exception e) {
                        throw new ThrottlingConfigurationException("The general configuration XML is incorrect!", e);
                    }
                }
            }
        }
    }

    static void setGeneralConfiguration(GeneralConfigurationBean generalConfiguration) {
        GeneralConfigurationUtils.generalConfiguration = generalConfiguration;
    }
}

