/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.sleeping;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.beans.configuration.backendservice.FeatureBean;
import org.vhorvath.valogato.common.constants.ThrConstants;
import org.vhorvath.valogato.common.dao.highlevel.usage.UsageDAOFactory;
import org.vhorvath.valogato.common.dao.lowlevel.cache.CacheDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.exception.ThrottlingRuntimeException;
import org.vhorvath.valogato.common.feature.FeatureParamGetter;
import org.vhorvath.valogato.common.utils.ThrottlingUtils;

public class SleepingInFeatureManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(String backendServiceName, FeatureBean featureBean) throws ThrottlingRuntimeException, ThrottlingConfigurationException {
        Integer period = FeatureParamGetter.getPeriod(featureBean);
        String strategy = FeatureParamGetter.getStrategy(featureBean);
        if (strategy.equals(ThrConstants.FeatureParamValue.maintiningFreeSlots.toString()) || strategy.equals(ThrConstants.FeatureParamValue.registeringRequestsIndividually.toString())) {
            try {
                CacheDAOFactory.getCache().lock(ThrottlingUtils.getSleepingReqKey(backendServiceName));
                UsageDAOFactory.getDAO().increaseNumberOfSleepingRequests(backendServiceName);
            }
            finally {
                CacheDAOFactory.getCache().unlock(ThrottlingUtils.getSleepingReqKey(backendServiceName));
            }
        }
        try {
            LOGGER.debug(String.format("##### Sleeping for %s miliseconds.", Integer.toString(period)));
            Thread.sleep(period.intValue());
        }
        catch (InterruptedException e) {
            throw new ThrottlingRuntimeException("Exception in the feature when trying to sleep for " + period + " milliseconds!", e);
        }
        if (strategy.equals(ThrConstants.FeatureParamValue.maintiningFreeSlots.toString()) || strategy.equals(ThrConstants.FeatureParamValue.registeringRequestsIndividually.toString())) {
            try {
                CacheDAOFactory.getCache().lock(ThrottlingUtils.getSleepingReqKey(backendServiceName));
                UsageDAOFactory.getDAO().decreaseNumberOfSleepingRequests(backendServiceName);
            }
            finally {
                CacheDAOFactory.getCache().unlock(ThrottlingUtils.getSleepingReqKey(backendServiceName));
            }
        }
    }
}

