/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.common.utils;

import org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.IBackendServiceConfigDAO;
import org.vhorvath.valogato.common.dao.highlevel.usage.IUsageDAO;
import org.vhorvath.valogato.common.dao.highlevel.waitingreq.IWaitingReqDAO;
import org.vhorvath.valogato.common.dao.lowlevel.cache.ICache;
import org.vhorvath.valogato.common.utils.AbstractStoredCache;

public final class ThrottlingStorage {
    private static final ThreadLocal<Boolean> storageChangedSleepingReqNumber = new ThreadLocal();
    private static final ThreadLocal<Boolean> storageAddedToWaitingReqList = new ThreadLocal();
    private static final ThreadLocal<Boolean> storageChangedFreq = new ThreadLocal();
    private static final ThreadLocal<AbstractStoredCache> storageCache = new ThreadLocal();
    private static final ThreadLocal<IBackendServiceConfigDAO> storageBackendServiceConfigDAOInstance = new ThreadLocal();
    private static final ThreadLocal<IUsageDAO> storageUsageDAOInstance = new ThreadLocal();
    private static final ThreadLocal<IWaitingReqDAO> storageWaitingReqDAOInstance = new ThreadLocal();
    private static final ThreadLocal<ICache> storageCacheInstance = new ThreadLocal();

    private ThrottlingStorage() {
    }

    public static void setAddedToWaitingReqList(Boolean added) {
        storageAddedToWaitingReqList.set(added);
    }

    public static Boolean isAddedToWaitingReqList() {
        return storageAddedToWaitingReqList.get();
    }

    public static void setChangedTheSleepingReqNumber(Boolean changed) {
        storageChangedSleepingReqNumber.set(changed);
    }

    public static Boolean isChangedTheSleepingReqNumber() {
        return storageChangedSleepingReqNumber.get();
    }

    public static void setChangedFreq(Boolean changed) {
        storageChangedFreq.set(changed);
    }

    public static Boolean isChangedFreq() {
        return storageChangedFreq.get();
    }

    public static AbstractStoredCache getCache() {
        return storageCache.get();
    }

    public static void setCache(AbstractStoredCache cache) {
        storageCache.set(cache);
    }

    public static IBackendServiceConfigDAO getBackendServiceConfigDAOInstance() {
        return storageBackendServiceConfigDAOInstance.get();
    }

    public static void setBackendServiceConfigDAOInstance(IBackendServiceConfigDAO instance) {
        storageBackendServiceConfigDAOInstance.set(instance);
    }

    public static IUsageDAO getUsageDAOInstance() {
        return storageUsageDAOInstance.get();
    }

    public static void setUsageDAOInstance(IUsageDAO instance) {
        storageUsageDAOInstance.set(instance);
    }

    public static IWaitingReqDAO getWaitingReqDAOInstance() {
        return storageWaitingReqDAOInstance.get();
    }

    public static void setWaitingReqDAOInstance(IWaitingReqDAO instance) {
        storageWaitingReqDAOInstance.set(instance);
    }

    public static ICache getCacheInstance() {
        return storageCacheInstance.get();
    }

    public static void setCacheInstance(ICache instance) {
        storageCacheInstance.set(instance);
    }

    public static void removeCache() {
        if (storageCache.get() != null) {
            storageCache.get().shutdown();
        }
        storageCache.remove();
    }

    public static void removeAll() {
        storageChangedSleepingReqNumber.remove();
        storageAddedToWaitingReqList.remove();
        storageChangedFreq.remove();
        storageBackendServiceConfigDAOInstance.remove();
        storageUsageDAOInstance.remove();
        storageWaitingReqDAOInstance.remove();
        storageCacheInstance.remove();
        ThrottlingStorage.removeCache();
    }

    public static void init() {
        ThrottlingStorage.setChangedTheSleepingReqNumber(false);
        ThrottlingStorage.setAddedToWaitingReqList(false);
        ThrottlingStorage.setChangedFreq(false);
        storageBackendServiceConfigDAOInstance.set(null);
        storageCache.set(null);
        storageUsageDAOInstance.set(null);
        storageWaitingReqDAOInstance.set(null);
        storageCacheInstance.set(null);
    }
}

