/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.core.controller;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServiceBean;
import org.vhorvath.valogato.common.beans.configuration.backendservice.FeatureBean;
import org.vhorvath.valogato.common.constants.ThrConstants;
import org.vhorvath.valogato.common.controller.IThrottlingController;
import org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.BackendServiceConfigDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.exception.ThrottlingRuntimeException;
import org.vhorvath.valogato.common.feature.IFeature;
import org.vhorvath.valogato.common.simulation.ISimulatedService;
import org.vhorvath.valogato.core.controller.features.ForwarderFeature;
import org.vhorvath.valogato.core.controller.features.SendBackFaultFeature;
import org.vhorvath.valogato.core.controller.features.WaitingFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureExecutor<RQ, RS, EX extends Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    public RS applyFeature(RQ req, String backendServiceName, ISimulatedService<RQ, RS, EX> simulatedInterface, String simulatedServiceName, BackendServiceBean backendServiceBean, IThrottlingController<RQ, RS, EX> throttlingContoller) throws ThrottlingConfigurationException, EX, ThrottlingRuntimeException {
        FeatureBean featureBean = BackendServiceConfigDAOFactory.getDAO().getFeature(backendServiceBean, simulatedServiceName);
        if (featureBean == null) {
            throw new ThrottlingConfigurationException(String.format("No feature has been found for the backend service %s!", backendServiceName));
        }
        IFeature<RQ, RS, EX> feature = this.getFeatureImpl(featureBean.getName());
        LOGGER.info(String.format("# The feature %s is going to be applied for the backend service %s. details: %s", featureBean.getName(), backendServiceName, featureBean));
        return feature.apply(backendServiceName, req, simulatedInterface, backendServiceBean, simulatedServiceName, throttlingContoller);
    }

    private IFeature<RQ, RS, EX> getFeatureImpl(String nameFeature) throws ThrottlingConfigurationException {
        Preconditions.checkArgument((nameFeature != null ? 1 : 0) != 0);
        IFeature feature = null;
        if (ThrConstants.Features.SendBackFaultFeature.toString().equals(nameFeature)) {
            feature = new SendBackFaultFeature();
        } else if (ThrConstants.Features.WaitingFeature.toString().equals(nameFeature)) {
            feature = new WaitingFeature();
        } else if (ThrConstants.Features.ForwarderFeature.toString().equals(nameFeature)) {
            feature = new ForwarderFeature();
        } else {
            throw new ThrottlingConfigurationException(String.format("Unknown feature! feature=%s", nameFeature));
        }
        return feature;
    }
}

