/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.core.controller;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServiceBean;
import org.vhorvath.valogato.common.constants.ThrConstants;
import org.vhorvath.valogato.common.controller.IThrottlingController;
import org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.BackendServiceConfigDAOFactory;
import org.vhorvath.valogato.common.dao.highlevel.waitingreq.WaitingReqDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.exception.ThrottlingRuntimeException;
import org.vhorvath.valogato.common.feature.FeatureParamGetter;
import org.vhorvath.valogato.common.simulation.ISimulatedService;
import org.vhorvath.valogato.common.utils.ThrottlingStorage;
import org.vhorvath.valogato.core.controller.FeatureExecutor;
import org.vhorvath.valogato.core.statistics.StatisticsStoreManager;
import org.vhorvath.valogato.core.transaction.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrottlingProcessController<RQ, RS, EX extends Exception>
implements IThrottlingController<RQ, RS, EX> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");
    private Calendar startOfProcessing = Calendar.getInstance();
    private String requestId = this.createUniqueReqId();
    private boolean afterSleeping = false;
    private StatisticsStoreManager statisticsStoreManager = null;
    private ResourceManager resourceManager = null;

    public ThrottlingProcessController() {
        MDC.put((String)"reqId", (String)this.requestId);
        ThrottlingStorage.init();
        this.statisticsStoreManager = new StatisticsStoreManager();
        this.resourceManager = new ResourceManager();
    }

    private RS innerProcessRequest(RQ req, ISimulatedService<RQ, RS, EX> simulatedInterface, String backendServiceName, String simulatedServiceName) throws EX {
        try {
            Preconditions.checkArgument((req != null ? 1 : 0) != 0);
            Preconditions.checkArgument((simulatedInterface != null ? 1 : 0) != 0);
            Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        }
        catch (Exception e) {
            return this.handleException("# Problems with the arguments!", e, simulatedInterface, req);
        }
        boolean can = false;
        BackendServiceBean backendServiceBean = null;
        try {
            backendServiceBean = BackendServiceConfigDAOFactory.getDAO().getBackendService(backendServiceName);
        }
        catch (Exception e) {
            return this.handleException("# ERROR: the config of the backend service " + backendServiceName + " couldn't be loaded!", e, simulatedInterface, req);
        }
        try {
            can = this.statisticsStoreManager.canBackendBeCalled(backendServiceName, this.requestId, simulatedServiceName, backendServiceBean, this.afterSleeping);
            LOGGER.debug(String.format("# Can the backend %s be called? = %s", backendServiceName, Boolean.toString(can)));
        }
        catch (Exception e) {
            return this.handleException("# ERROR: the DiagnosticStore was not able to be called!", e, simulatedInterface, req);
        }
        if (!can) {
            try {
                this.registerRequestIdInWaitingReqList(backendServiceBean, simulatedServiceName, can, simulatedInterface);
            }
            catch (ThrottlingConfigurationException e) {
                return this.handleException("# ERROR: unable to register the request into the waiting request list!", e, simulatedInterface, req);
            }
            try {
                LOGGER.debug("# The backend service cannot be called and a feature will be used ...");
                return new FeatureExecutor<RQ, RS, EX>().applyFeature(req, backendServiceName, simulatedInterface, simulatedServiceName, backendServiceBean, this);
            }
            catch (ThrottlingConfigurationException tce) {
                return this.handleException("# ERROR: the feature couldn't be appplied!", tce, simulatedInterface, req);
            }
            catch (ThrottlingRuntimeException tre) {
                return this.handleException("# ERROR: runtime error occurred when tried to apply the feature!", tre, simulatedInterface, req);
            }
        }
        LOGGER.debug("# The backend service may be called and it is going to be called ...");
        return simulatedInterface.forwardRequest(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public RS processRequest(RQ req, ISimulatedService<RQ, RS, EX> simulatedInterface, String backendServiceName, String simulatedServiceName) throws EX {
        LOGGER.info(String.format("# The method ThrController.processRequest has been called! backendServiceNames = %s, requestId = %s, simulatedServiceName = %s", backendServiceName, this.requestId, simulatedServiceName));
        this.afterSleeping = false;
        RS RS = this.innerProcessRequest(req, simulatedInterface, backendServiceName, simulatedServiceName);
        try {
            this.resourceManager.releaseResources(backendServiceName, this.requestId, this.statisticsStoreManager, simulatedServiceName);
        }
        catch (Exception e) {
            LOGGER.error("# ERROR: Error when trying to release the resources! ", (Throwable)e);
        }
        LOGGER.info(String.format("# The method ThrController.processRequest has finished. backendServiceNames = %s, requestId = %s, simulatedServiceName = %s", backendServiceName, this.requestId, simulatedServiceName));
        try {
            ThrottlingStorage.removeAll();
        }
        finally {
            MDC.remove((String)"reqId");
        }
        return RS;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        this.resourceManager.releaseResources(backendServiceName, this.requestId, this.statisticsStoreManager, simulatedServiceName);
                    }
                    catch (Exception e) {
                        LOGGER.error("# ERROR: Error when trying to release the resources! ", (Throwable)e);
                    }
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    LOGGER.info(String.format("# The method ThrController.processRequest has finished. backendServiceNames = %s, requestId = %s, simulatedServiceName = %s", backendServiceName, this.requestId, simulatedServiceName));
                    try {
                        ThrottlingStorage.removeAll();
                    }
                    finally {
                        MDC.remove((String)"reqId");
                    }
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public RS processRequestAfterSleeping(RQ req, ISimulatedService<RQ, RS, EX> simulatedInterface, String backendServiceName, String simulatedServiceName, BackendServiceBean backendServiceBean) throws EX {
        LOGGER.info(String.format("# The method ThrController.processRequestAfterSleeping has been called! backendServiceNames = %s, requestId = %s, simulatedServiceName = %s", backendServiceName, this.requestId, simulatedServiceName));
        this.afterSleeping = true;
        return this.innerProcessRequest(req, simulatedInterface, backendServiceName, simulatedServiceName);
    }

    @Override
    public Calendar getStartOfProcessing() {
        return this.startOfProcessing;
    }

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    private void registerRequestIdInWaitingReqList(BackendServiceBean backendServiceBean, String simulatedServiceName, boolean can, ISimulatedService<RQ, RS, EX> simulatedInterface) throws ThrottlingConfigurationException, EX {
        String strategy;
        if (!can && !this.afterSleeping && (strategy = FeatureParamGetter.getStrategy(backendServiceBean, simulatedServiceName)) != null && strategy.equals(ThrConstants.FeatureParamValue.registeringRequestsIndividually.toString())) {
            Integer waitingReqListMaxSize = FeatureParamGetter.getWaitingReqListMaxSize(backendServiceBean, simulatedServiceName);
            Integer maxNumberOfWaitingReqs = FeatureParamGetter.getMaxNumberOfWaitingReqs(backendServiceBean, simulatedServiceName);
            boolean wasAbleToAdd = WaitingReqDAOFactory.getDAO().registerRequest(this.requestId, backendServiceBean, simulatedServiceName, waitingReqListMaxSize, maxNumberOfWaitingReqs);
            if (!wasAbleToAdd) {
                throw simulatedInterface.buildFault(String.format("WaitingFeature: The waiting requests have exceeded the limit (%s)!", maxNumberOfWaitingReqs));
            }
            ThrottlingStorage.setAddedToWaitingReqList(true);
        }
    }

    private RS handleException(String errorMessage, Exception e, ISimulatedService<RQ, RS, EX> simulatedInterface, RQ req) throws EX {
        LOGGER.error(errorMessage, (Throwable)e);
        LOGGER.info("# The backend service is going to be called directly.");
        return simulatedInterface.forwardRequest(req);
    }

    private String createUniqueReqId() {
        String machineName = "";
        try {
            machineName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOGGER.warn("# The name of the machine cannot be determined! " + e.getMessage());
        }
        String nanoTime = Long.toString(System.nanoTime());
        return machineName + "<" + UUID.randomUUID().toString().replace("-", "") + ">" + nanoTime;
    }
}

