/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.core.controller.features;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServiceBean;
import org.vhorvath.valogato.common.beans.configuration.backendservice.FeatureBean;
import org.vhorvath.valogato.common.constants.ThrConstants;
import org.vhorvath.valogato.common.controller.IThrottlingController;
import org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.BackendServiceConfigDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.exception.ThrottlingRuntimeException;
import org.vhorvath.valogato.common.feature.IFeature;
import org.vhorvath.valogato.common.simulation.ISimulatedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwarderFeature<RQ, RS, EX extends Exception>
implements IFeature<RQ, RS, EX> {
    private static Map<String, String> endpointMapConstant = Collections.synchronizedMap(new HashMap());
    private static Map<String, Queue<String>> endpointMapQueue = Collections.synchronizedMap(new HashMap());
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    @Override
    public RS apply(String backendServiceName, RQ req, ISimulatedService<RQ, RS, EX> simulatedInterface, BackendServiceBean backendServiceBean, String simulatedServiceName, IThrottlingController<RQ, RS, EX> thrController) throws EX, ThrottlingConfigurationException, ThrottlingRuntimeException {
        Preconditions.checkArgument((backendServiceBean != null ? 1 : 0) != 0);
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((simulatedInterface != null ? 1 : 0) != 0);
        Preconditions.checkArgument((thrController != null ? 1 : 0) != 0);
        FeatureBean featureBean = BackendServiceConfigDAOFactory.getDAO().getFeature(backendServiceBean, simulatedServiceName);
        if (featureBean == null) {
            throw new ThrottlingConfigurationException(String.format("No feature has been found for the backend service %s!", backendServiceName));
        }
        this.addToStatic(backendServiceName, simulatedServiceName, featureBean);
        String endpoint = this.getEndpoint(backendServiceName, simulatedServiceName);
        LOGGER.debug(String.format("### The ForwarderFeature will use the endpoint '%s'", endpoint));
        simulatedInterface.setEndpoint(endpoint);
        return simulatedInterface.forwardRequest(req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToStatic(String backendServiceName, String simulatedServiceName, FeatureBean featureBean) throws ThrottlingConfigurationException {
        Map<String, Queue<String>> map = endpointMapQueue;
        synchronized (map) {
            String key = backendServiceName + (simulatedServiceName != null ? "-" + simulatedServiceName : "");
            String endpoints = featureBean.getParams().get(ThrConstants.FeatureParam.endpoints.toString());
            String endpointsInStaticMaps = endpointMapConstant.get(key);
            if (endpointsInStaticMaps == null) {
                if (endpoints == null) {
                    throw new ThrottlingConfigurationException(String.format("The feature of the backend service doesn't have %s parameter! backendService=%s, simulatedService=%s", ThrConstants.FeatureParam.endpoints.toString(), backendServiceName, simulatedServiceName));
                }
                endpointMapConstant.remove(key);
                endpointMapConstant.put(key, endpoints);
                endpointMapQueue.remove(key);
                endpointMapQueue.put(key, this.getEndpointsAsQueue(featureBean));
            } else if (!endpoints.equals(endpointsInStaticMaps)) {
                endpointMapConstant.remove(key);
                endpointMapConstant.put(key, endpoints);
                endpointMapQueue.remove(key);
                endpointMapQueue.put(key, this.getEndpointsAsQueue(featureBean));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEndpoint(String backendServiceName, String simulatedServiceName) {
        Map<String, Queue<String>> map = endpointMapQueue;
        synchronized (map) {
            String key = backendServiceName + (simulatedServiceName != null ? "-" + simulatedServiceName : "");
            Queue<String> queue = endpointMapQueue.get(key);
            String endpoint = queue.poll();
            queue.add(endpoint);
            return endpoint;
        }
    }

    private Queue<String> getEndpointsAsQueue(FeatureBean featureBean) {
        LinkedList<String> endpointQueue = new LinkedList<String>();
        String endpoints = featureBean.getParams().get(ThrConstants.FeatureParam.endpoints.toString());
        for (String endpoint : endpoints.trim().split(";")) {
            endpointQueue.add(endpoint.trim());
        }
        return endpointQueue;
    }
}

