/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.core.controller.features;

import com.google.common.base.Preconditions;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServiceBean;
import org.vhorvath.valogato.common.beans.configuration.backendservice.FeatureBean;
import org.vhorvath.valogato.common.constants.ThrConstants;
import org.vhorvath.valogato.common.controller.IThrottlingController;
import org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.BackendServiceConfigDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.exception.ThrottlingRuntimeException;
import org.vhorvath.valogato.common.feature.IFeature;
import org.vhorvath.valogato.common.simulation.ISimulatedService;
import org.vhorvath.valogato.common.sleeping.SleepingInFeatureManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitingFeature<RQ, RS, EX extends Exception>
implements IFeature<RQ, RS, EX> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    @Override
    public RS apply(String backendServiceName, RQ req, ISimulatedService<RQ, RS, EX> simulatedInterface, BackendServiceBean backendServiceBean, String simulatedServiceName, IThrottlingController<RQ, RS, EX> thrController) throws EX, ThrottlingConfigurationException, ThrottlingRuntimeException {
        Preconditions.checkArgument((backendServiceBean != null ? 1 : 0) != 0);
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((simulatedInterface != null ? 1 : 0) != 0);
        Preconditions.checkArgument((thrController != null ? 1 : 0) != 0);
        FeatureBean featureBean = BackendServiceConfigDAOFactory.getDAO().getFeature(backendServiceBean, simulatedServiceName);
        if (featureBean == null) {
            throw new ThrottlingConfigurationException(String.format("No feature has been found for the backend service %s!", backendServiceName));
        }
        SleepingInFeatureManager sleepingManager = new SleepingInFeatureManager();
        sleepingManager.wait(backendServiceName, featureBean);
        Integer averageResponseTime = BackendServiceConfigDAOFactory.getDAO().getAverageResponseTime(backendServiceName);
        Integer n = averageResponseTime = averageResponseTime == null ? ThrConstants.DEFAULT_AVERAGE_RESPONSE_TIME : averageResponseTime;
        if (Calendar.getInstance().getTimeInMillis() - thrController.getStartOfProcessing().getTimeInMillis() > (long)averageResponseTime.intValue()) {
            LOGGER.debug(String.format("WaitingFeature: the average response (%s) time has been exceeded!", averageResponseTime.toString()));
            throw simulatedInterface.buildFault(String.format("WaitingFeature: the average response (%s) time has been exceeded!", averageResponseTime.toString()));
        }
        return thrController.processRequestAfterSleeping(req, simulatedInterface, backendServiceName, simulatedServiceName, backendServiceBean);
    }
}

