/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.core.statistics;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServiceBean;
import org.vhorvath.valogato.common.beans.usage.BackendServiceFreqBean;
import org.vhorvath.valogato.common.beans.usage.BackendServiceSleepingReqBean;
import org.vhorvath.valogato.common.constants.ThrConstants;
import org.vhorvath.valogato.common.dao.highlevel.usage.UsageDAOFactory;
import org.vhorvath.valogato.common.dao.highlevel.waitingreq.WaitingReqDAOFactory;
import org.vhorvath.valogato.common.dao.lowlevel.cache.CacheDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.feature.FeatureParamGetter;
import org.vhorvath.valogato.common.utils.ThrottlingStorage;
import org.vhorvath.valogato.common.utils.ThrottlingUtils;

public class StatisticsStoreManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBackendBeCalled(String backendServiceName, String requestId, String simulatedServiceName, BackendServiceBean backendServiceBean, boolean afterSleeping) throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("### The method StatisticsStoreManager.canBackendBeCalled has been called! backendServiceName = %s, requestId = %s, simulatedServiceName = %s, afterSleeping = %s", backendServiceName, requestId, simulatedServiceName, Boolean.toString(afterSleeping)));
        Preconditions.checkArgument((backendServiceName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((requestId != null ? 1 : 0) != 0);
        Integer numberOfServedReq = 0;
        CacheDAOFactory.getCache().lock(ThrottlingUtils.getFreqKey(backendServiceName));
        try {
            boolean can = true;
            BackendServiceFreqBean beanFreq = UsageDAOFactory.getDAO().getFreqOfBackendService(backendServiceName);
            BackendServiceSleepingReqBean beanSleepingReq = this.getBackendServiceSleepingReqBean(backendServiceBean, simulatedServiceName, backendServiceName);
            numberOfServedReq = beanFreq == null ? null : beanFreq.getFrequency();
            Integer maxLoading = backendServiceBean.getMaxLoading();
            Integer numberOfSleepingRequests = beanSleepingReq == null ? 0 : (beanSleepingReq.getNumberOfSleepingRequests() == null ? 0 : beanSleepingReq.getNumberOfSleepingRequests());
            if (numberOfServedReq == null) {
                if (maxLoading > 0) {
                    LOGGER.debug("### The backend service %s is not in the store yet, probably it will be registered... (it depends on the result of the method WaitingReqDAOFactory.getDAO().isRequestNextWaiting(...).)");
                    numberOfServedReq = 0;
                } else {
                    LOGGER.debug("### The max loading number is zero.");
                    can = false;
                }
            } else {
                int freeSlots = this.getFreeSlots(maxLoading, numberOfServedReq, numberOfSleepingRequests, afterSleeping);
                if (freeSlots > 0) {
                    LOGGER.info(String.format("### The backend service %s probably can be called...(it depends on the result of the method WaitingReqDAOFactory.getDAO().isRequestNextWaiting(...).)", backendServiceName));
                } else {
                    LOGGER.info(String.format("### The backend service %s cannot be called! the number of the served requests: %s, maximum loading: %s, the number of sleeping requests: %s", backendServiceName, Integer.toString(numberOfServedReq), Integer.toString(maxLoading), Integer.toString(numberOfSleepingRequests)));
                    can = false;
                }
            }
            if (can && afterSleeping && !WaitingReqDAOFactory.getDAO().isRequestNextWaiting(requestId, backendServiceBean, simulatedServiceName)) {
                LOGGER.info("### The backend service cannot be called as there is other request that started to wait earlier...");
                can = false;
            }
            if (can) {
                LOGGER.debug(String.format("### The frequency will be increased. numberOfServedReq=%s", numberOfServedReq));
                this.manage(backendServiceName, ThrConstants.OpType.REGISTER, numberOfServedReq);
                ThrottlingStorage.setChangedFreq(Boolean.TRUE);
                if (ThrottlingStorage.isAddedToWaitingReqList().booleanValue()) {
                    LOGGER.debug(String.format("### Unregistering the request from waiting req list. backendservice = %s", backendServiceName));
                    Integer waitingReqListMaxSize = FeatureParamGetter.getWaitingReqListMaxSize(backendServiceBean, simulatedServiceName);
                    Integer maxNumberOfWaitingReqs = FeatureParamGetter.getMaxNumberOfWaitingReqs(backendServiceBean, simulatedServiceName);
                    WaitingReqDAOFactory.getDAO().unregisterRequest(requestId, waitingReqListMaxSize, maxNumberOfWaitingReqs);
                    ThrottlingStorage.setAddedToWaitingReqList(false);
                }
            }
            boolean bl = can;
            return bl;
        }
        finally {
            CacheDAOFactory.getCache().unlock(ThrottlingUtils.getFreqKey(backendServiceName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackendServiceSleepingReqBean getBackendServiceSleepingReqBean(BackendServiceBean backendServiceBean, String simulatedServiceName, String backendServiceName) throws ThrottlingConfigurationException {
        BackendServiceSleepingReqBean beanSleepingReq = null;
        String strategy = FeatureParamGetter.getStrategy(backendServiceBean, simulatedServiceName);
        if (strategy != null && !strategy.equals(ThrConstants.FeatureParamValue.fast.toString())) {
            try {
                CacheDAOFactory.getCache().lock(ThrottlingUtils.getSleepingReqKey(backendServiceName));
                beanSleepingReq = UsageDAOFactory.getDAO().getSleepingReqOfBackendService(backendServiceName);
            }
            finally {
                CacheDAOFactory.getCache().unlock(ThrottlingUtils.getSleepingReqKey(backendServiceName));
            }
        }
        return beanSleepingReq;
    }

    private int getFreeSlots(Integer maxLoading, Integer numberOfServedReq, Integer numberOfSleepingRequests, boolean afterSleeping) {
        int freeSlots = 0;
        freeSlots = !afterSleeping ? maxLoading - numberOfServedReq - numberOfSleepingRequests : maxLoading - numberOfServedReq;
        LOGGER.debug(String.format("### freeSlots:%s, numberOfServedReq: %s, getMaxLoading: %s, numberOfSleepingRequests: %s, afterSleeping: %s", Integer.toString(freeSlots), Integer.toString(numberOfServedReq), Integer.toString(maxLoading), Integer.toString(numberOfSleepingRequests), Boolean.toString(afterSleeping)));
        return freeSlots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String backendServiceName) throws ThrottlingConfigurationException {
        try {
            CacheDAOFactory.getCache().lock(ThrottlingUtils.getFreqKey(backendServiceName));
            BackendServiceFreqBean bean = UsageDAOFactory.getDAO().getFreqOfBackendService(backendServiceName);
            this.manage(backendServiceName, ThrConstants.OpType.UNREGISTER, bean.getFrequency());
        }
        finally {
            CacheDAOFactory.getCache().unlock(ThrottlingUtils.getFreqKey(backendServiceName));
        }
    }

    private void manage(String backendServiceName, ThrConstants.OpType opType, Integer numberOfServedReq) throws ThrottlingConfigurationException {
        LOGGER.debug(String.format("### The method DiagnosticStoreManager.manage has been called! backendServiceName: %s, opType: %s, numberOfServedReq: %d", backendServiceName, opType.toString(), numberOfServedReq));
        if (numberOfServedReq == null) {
            throw new ThrottlingConfigurationException(String.format("The backend service %s has not been loaded yet!", backendServiceName));
        }
        LOGGER.debug(String.format("### manage - numberOfServedReq: %s", numberOfServedReq));
        if (opType.equals((Object)ThrConstants.OpType.UNREGISTER)) {
            UsageDAOFactory.getDAO().setFrequency(backendServiceName, numberOfServedReq == 0 ? 0 : numberOfServedReq - 1);
        } else {
            UsageDAOFactory.getDAO().setFrequency(backendServiceName, numberOfServedReq + 1);
        }
    }
}

