/*
 * Decompiled with CFR 0.152.
 */
package org.vhorvath.valogato.core.transaction;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vhorvath.valogato.common.beans.configuration.backendservice.BackendServiceBean;
import org.vhorvath.valogato.common.dao.highlevel.configuration.backendservice.BackendServiceConfigDAOFactory;
import org.vhorvath.valogato.common.dao.highlevel.usage.UsageDAOFactory;
import org.vhorvath.valogato.common.dao.highlevel.waitingreq.WaitingReqDAOFactory;
import org.vhorvath.valogato.common.exception.ThrottlingConfigurationException;
import org.vhorvath.valogato.common.exception.ThrottlingRuntimeException;
import org.vhorvath.valogato.common.feature.FeatureParamGetter;
import org.vhorvath.valogato.common.utils.ThrottlingStorage;
import org.vhorvath.valogato.core.statistics.StatisticsStoreManager;

public class ResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Throttling-Core");

    public void releaseResources(String backendServiceName, String requestId, StatisticsStoreManager statisticsStoreManager, String simulatedServiceName) throws ThrottlingConfigurationException, ThrottlingRuntimeException {
        LOGGER.debug(String.format("### Releasing the reserved resources. isChangedFreq=%s, isChangedTheWaitingReqNumber=%s, isAddedToWaitingReqList=%s", ThrottlingStorage.isChangedFreq().toString(), ThrottlingStorage.isChangedTheSleepingReqNumber().toString(), ThrottlingStorage.isAddedToWaitingReqList().toString()));
        if (ThrottlingStorage.isChangedFreq().booleanValue()) {
            LOGGER.debug(String.format("### Decreasing the number of frequency. backendservice = %s", backendServiceName));
            statisticsStoreManager.unregister(backendServiceName);
        }
        if (ThrottlingStorage.isChangedTheSleepingReqNumber().booleanValue()) {
            LOGGER.debug(String.format("### Decreasing the number of waiting requests as it has not been decreased yet. backendservice = %s", backendServiceName));
            UsageDAOFactory.getDAO().decreaseNumberOfSleepingRequests(backendServiceName);
        }
        if (ThrottlingStorage.isAddedToWaitingReqList().booleanValue()) {
            LOGGER.debug(String.format("### Unregistering the request from waiting req list. backendservice = %s", backendServiceName));
            BackendServiceBean backendServiceBean = BackendServiceConfigDAOFactory.getDAO().getBackendService(backendServiceName);
            Integer waitingReqListMaxSize = FeatureParamGetter.getWaitingReqListMaxSize(backendServiceBean, simulatedServiceName);
            Integer maxNumberOfWaitingReqs = FeatureParamGetter.getMaxNumberOfWaitingReqs(backendServiceBean, simulatedServiceName);
            WaitingReqDAOFactory.getDAO().unregisterRequest(requestId, waitingReqListMaxSize, maxNumberOfWaitingReqs);
        }
    }
}

