/**
 *   Copyright 2012 Wicked Charts (http://wicked-charts.googlecode.com)
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package com.googlecode.wickedcharts.highcharts.jackson;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.googlecode.wickedcharts.highcharts.options.MinorTickInterval;

public class MinorTickIntervalSerializer extends JsonSerializer<MinorTickInterval> {

	@Override
	public void serialize(final MinorTickInterval value, final JsonGenerator jgen, final SerializerProvider provider)
	    throws IOException, JsonProcessingException {
		if (value.getAuto()) {
			jgen.writeString("auto");
		} else if (value.getInterval() != null) {
			jgen.writeNumber(value.getInterval().doubleValue());
		} else if (value.isNull()) {
			jgen.writeNull();
		} else {
			throw new IllegalStateException("Invalid state of TickInterval: " + value);
		}

	}

}
