/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options.color;

import com.googlecode.wickedcharts.highcharts.options.color.ColorReference;
import com.googlecode.wickedcharts.highcharts.options.color.Gradient;
import java.util.Arrays;
import java.util.List;

public class LinearGradient
extends Gradient {
    private static final long serialVersionUID = 1L;
    private final List<Number> linearGradient;

    public LinearGradient(GradientDirection direction) {
        switch (direction) {
            case HORIZONTAL: {
                this.linearGradient = Arrays.asList(0, 0, 0, 1);
                break;
            }
            case VERTICAL: {
                this.linearGradient = Arrays.asList(0, 0, 1, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid GradientDirection: " + (Object)((Object)direction));
            }
        }
    }

    private LinearGradient(List<Number> linearGradient) {
        this.linearGradient = linearGradient;
    }

    public LinearGradient(Number x1, Number y1, Number x2, Number y2) {
        this.linearGradient = Arrays.asList(x1, y1, x2, y2);
    }

    @Override
    protected ColorReference copy() {
        LinearGradient copy = new LinearGradient(this.linearGradient);
        copy.setBrightness(this.getBrightness());
        copy.addStopsInternal(this.getStops());
        return copy;
    }

    public List<Number> getLinearGradient() {
        return this.linearGradient;
    }

    public static enum GradientDirection {
        HORIZONTAL,
        VERTICAL;

    }
}

