/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options.series;

import com.googlecode.wickedcharts.highcharts.options.Center;
import com.googlecode.wickedcharts.highcharts.options.DataLabels;
import com.googlecode.wickedcharts.highcharts.options.Marker;
import com.googlecode.wickedcharts.highcharts.options.PixelOrPercent;
import com.googlecode.wickedcharts.highcharts.options.PointPlacement;
import com.googlecode.wickedcharts.highcharts.options.SeriesType;
import com.googlecode.wickedcharts.highcharts.options.Tooltip;
import com.googlecode.wickedcharts.highcharts.options.color.ColorReference;
import com.googlecode.wickedcharts.highcharts.options.color.SimpleColor;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class Series<D>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private SeriesType type;
    private List<D> data;
    private Integer legendIndex;
    private String stack;
    private Integer xAxis;
    private Integer yAxis;
    private Marker marker;
    private PixelOrPercent size;
    private Boolean showInLegend;
    private DataLabels dataLabels;
    private ColorReference color;
    private Center center;
    private PixelOrPercent innerSize;
    private Number pointInterval;
    private Number pointStart;
    private PointPlacement pointPlacement;
    private Tooltip tooltip;

    public Series<D> addPoint(D point) {
        if (this.data == null) {
            this.data = new ArrayList<D>();
        }
        this.data.add(point);
        return this;
    }

    public Center getCenter() {
        return this.center;
    }

    public ColorReference getColor() {
        return this.color;
    }

    public List<D> getData() {
        return this.data;
    }

    public DataLabels getDataLabels() {
        return this.dataLabels;
    }

    public PixelOrPercent getInnerSize() {
        return this.innerSize;
    }

    public Integer getLegendIndex() {
        return this.legendIndex;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public String getName() {
        return this.name;
    }

    public Number getPointInterval() {
        return this.pointInterval;
    }

    public PointPlacement getPointPlacement() {
        return this.pointPlacement;
    }

    public Number getPointStart() {
        return this.pointStart;
    }

    public Boolean getShowInLegend() {
        return this.showInLegend;
    }

    public PixelOrPercent getSize() {
        return this.size;
    }

    public String getStack() {
        return this.stack;
    }

    public SeriesType getType() {
        return this.type;
    }

    public Integer getxAxis() {
        return this.xAxis;
    }

    public Integer getyAxis() {
        return this.yAxis;
    }

    public Series<D> setCenter(Center center) {
        this.center = center;
        return this;
    }

    public Series<D> setColor(Color color) {
        this.color = new SimpleColor(color);
        return this;
    }

    public Series<D> setColor(ColorReference color) {
        this.color = color;
        return this;
    }

    public Series<D> setData(D ... data) {
        this.data = Arrays.asList(data);
        return this;
    }

    public Series<D> setData(List<D> data) {
        this.data = data;
        return this;
    }

    public Series<D> setDataLabels(DataLabels dataLabels) {
        this.dataLabels = dataLabels;
        return this;
    }

    public Series<D> setInnerSize(PixelOrPercent innerSize) {
        this.innerSize = innerSize;
        return this;
    }

    public Series<D> setLegendIndex(Integer legendIndex) {
        this.legendIndex = legendIndex;
        return this;
    }

    public Series<D> setMarker(Marker marker) {
        this.marker = marker;
        return this;
    }

    public Series<D> setName(String name) {
        this.name = name;
        return this;
    }

    public Series<D> setPointInterval(Number pointInterval) {
        this.pointInterval = pointInterval;
        return this;
    }

    public Series<D> setPointPlacement(PointPlacement pointPlacement) {
        this.pointPlacement = pointPlacement;
        return this;
    }

    public Series<D> setPointStart(Number pointStart) {
        this.pointStart = pointStart;
        return this;
    }

    public Series<D> setShowInLegend(Boolean showInLegend) {
        this.showInLegend = showInLegend;
        return this;
    }

    public Series<D> setSize(PixelOrPercent size) {
        this.size = size;
        return this;
    }

    public Series<D> setStack(String stack) {
        this.stack = stack;
        return this;
    }

    public Series<D> setType(SeriesType type) {
        this.type = type;
        return this;
    }

    public Series<D> setxAxis(Integer xAxis) {
        this.xAxis = xAxis;
        return this;
    }

    public Series<D> setyAxis(Integer yAxis) {
        this.yAxis = yAxis;
        return this;
    }

    public Series<D> setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }
}

