/**
 *   Copyright 2012 Wicked Charts (http://wicked-charts.googlecode.com)
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 */
package com.googlecode.wickedcharts.highcharts.options;

import com.googlecode.wickedcharts.highcharts.json.LowercaseEnum;

/**
 * Defines the configuration of the "overflow" option.
 * 
 * @see <a href="http
 *      ://api.highcharts.com/highcharts#plotOptions.column.dataLabels
 *      .overflow">http
 *      ://api.highcharts.com/highcharts#plotOptions.column.dataLabels
 *      .overflow</a>
 * 
 * @author Tom Hombergs (tom.hombergs@gmail.com)
 */
public enum Overflow implements LowercaseEnum {

	JUSTIFY;

}
