/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options.util;

import com.googlecode.wickedcharts.highcharts.options.ChartOptions;
import com.googlecode.wickedcharts.highcharts.options.ChartType;
import com.googlecode.wickedcharts.highcharts.options.Events;
import com.googlecode.wickedcharts.highcharts.options.Function;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.series.Point;
import com.googlecode.wickedcharts.highcharts.options.series.Series;

public class OptionsUtil {
    private static OptionsUtil INSTANCE = new OptionsUtil();

    public static OptionsUtil getInstance() {
        return INSTANCE;
    }

    private OptionsUtil() {
    }

    public void copyRenderTo(Options from, Options to) {
        if (to.getChartOptions() == null) {
            to.setChartOptions(new ChartOptions());
        }
        to.getChartOptions().setRenderTo(from.getChartOptions().getRenderTo());
    }

    public void setRenderTo(Options options, String renderTo) {
        if (options.getChartOptions() == null) {
            options.setChartOptions(new ChartOptions());
        }
        options.getChartOptions().setRenderTo(renderTo);
    }

    public void setChartEventsLoad(Options options, Function function) {
        if (options.getChartOptions().getEvents() == null) {
            options.getChartOptions().setEvents(new Events());
        }
        if (options.getChartOptions().getEvents().getLoad() == null) {
            options.getChartOptions().getEvents().setLoad(function);
        }
    }

    public static boolean needsHighchartsMoreJs(Options options) {
        return OptionsUtil.hasPolar(options) || OptionsUtil.hasChartTypeNeedingMoreJs(options);
    }

    public static boolean needsExportingJs(Options options) {
        return options.getExporting() == null || options.getExporting().getEnabled() != null && options.getExporting().getEnabled() != false;
    }

    private static boolean hasPolar(Options options) {
        return options.getChartOptions() != null && options.getChartOptions().getPolar() != null && options.getChartOptions().getPolar() != false;
    }

    private static boolean hasChartTypeNeedingMoreJs(Options options) {
        if (options.getChartOptions() != null && options.getChartOptions().getType() != null && options.getChartOptions().getType().getChartType() == ChartType.ADVANCED) {
            return true;
        }
        if (options.getSeries() != null) {
            for (Series series : options.getSeries()) {
                if (series.getType() == null || series.getType().getChartType() != ChartType.ADVANCED) continue;
                return true;
            }
        }
        return false;
    }

    public static Series<?> getSeriesWithWickedChartsId(Options options, int wickedChartsId) {
        for (Series series : options.getSeries()) {
            if (series.getWickedChartsId() != wickedChartsId) continue;
            return series;
        }
        return null;
    }

    public static Point getPointWithWickedChartsId(Options options, int wickedChartsId) {
        for (Series series : options.getSeries()) {
            for (Object object : series.getData()) {
                if (!(object instanceof Point)) break;
                Point point = (Point)object;
                if (point.getWickedChartsId() != wickedChartsId) continue;
                return point;
            }
        }
        return null;
    }
}

