/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket14.highcharts;

import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.theme.Theme;
import com.googlecode.wickedcharts.wicket14.highcharts.features.basic.ChartBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;

public class Chart
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private Options options;
    private Theme theme;
    private JavascriptResourceReference themeReference;
    private String themeUrl;

    public Chart(String id, Options options) {
        super(id);
        this.options = options;
        this.setOutputMarkupId(true);
        this.add(new IBehavior[]{this.createChartBehavior()});
    }

    public Chart(String id, Options options, Theme theme) {
        super(id);
        this.options = options;
        this.setTheme(theme);
        this.setOutputMarkupId(true);
        this.add(new IBehavior[]{this.createChartBehavior()});
    }

    public Options getOptions() {
        return this.options;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public JavascriptResourceReference getThemeReference() {
        return this.themeReference;
    }

    public String getThemeUrl() {
        return this.themeUrl;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setTheme(JavascriptResourceReference theme) {
        if (this.theme != null || this.themeUrl != null) {
            throw new IllegalStateException("A theme can only be defined once. Calling different setTheme methods is not allowed!");
        }
        this.themeReference = theme;
    }

    public void setTheme(String themeUrl) {
        if (this.themeReference != null || this.theme != null) {
            throw new IllegalStateException("A theme can only be defined once. Calling different setTheme methods is not allowed!");
        }
        this.themeUrl = themeUrl;
    }

    public void setTheme(Theme theme) {
        if (this.themeReference != null || this.themeUrl != null) {
            throw new IllegalStateException("A theme can only be defined once. Calling different setTheme methods is not allowed!");
        }
        this.theme = theme;
    }

    public void setThemeReference(JavascriptResourceReference themeReference) {
        this.themeReference = themeReference;
    }

    public void setThemeUrl(String themeUrl) {
        this.themeUrl = themeUrl;
    }

    protected ChartBehavior createChartBehavior() {
        return new ChartBehavior(this);
    }
}

