/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket14.highcharts.features.drilldown;

import com.googlecode.wickedcharts.highcharts.jackson.JsonRenderer;
import com.googlecode.wickedcharts.highcharts.options.Events;
import com.googlecode.wickedcharts.highcharts.options.Function;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.PlotOptions;
import com.googlecode.wickedcharts.highcharts.options.PlotOptionsChoice;
import com.googlecode.wickedcharts.highcharts.options.PointOptions;
import com.googlecode.wickedcharts.highcharts.options.SeriesType;
import com.googlecode.wickedcharts.highcharts.options.drilldown.DrilldownFunction;
import com.googlecode.wickedcharts.highcharts.options.processing.IOptionsProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.OptionsProcessorContext;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import com.googlecode.wickedcharts.wicket14.highcharts.JsonRendererFactory;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;

public class DrilldownProcessor
implements IOptionsProcessor {
    private static final String JS_DRILLDOWN_ARRAY_NAME = "drilldownOptions";
    private final Component component;
    private final IHeaderResponse response;

    public DrilldownProcessor(Component component, IHeaderResponse response) {
        this.component = component;
        this.response = response;
    }

    public void processOptions(Options options, OptionsProcessorContext context) {
        if (!context.getDrilldownOptions().isEmpty()) {
            this.modifyDrilldownOptions(options, context);
            this.addDrilldownOptionsArray(context);
            this.addJavascriptDependencies(this.response);
        }
    }

    private void modifyDrilldownOptions(Options options, OptionsProcessorContext context) {
        for (Options drilldownOptions : context.getDrilldownOptions()) {
            OptionsUtil.getInstance().copyRenderTo(options, drilldownOptions);
            this.addDrilldownFunction(drilldownOptions, context);
        }
    }

    private void addDrilldownOptionsArray(OptionsProcessorContext context) {
        JsonRenderer renderer = JsonRendererFactory.getInstance().getRenderer();
        this.response.renderJavascript((CharSequence)MessageFormat.format("var {0};", JS_DRILLDOWN_ARRAY_NAME), "drilldownOptions-init");
        this.response.renderOnDomReadyJavascript(MessageFormat.format("{0} = {1};", this.getDrilldownArrayName(this.component), renderer.toJson((Object)context.getDrilldownOptions())));
    }

    private void addJavascriptDependencies(IHeaderResponse headerResponse) {
        headerResponse.renderJavascriptReference((ResourceReference)new JavascriptResourceReference(DrilldownFunction.class, "drilldown.js"));
    }

    private void addDrilldownFunction(Options options, OptionsProcessorContext context) {
        SeriesType chartType = options.getChartOptions().getType();
        if (options.getPlotOptions() == null) {
            options.setPlotOptions(new PlotOptionsChoice());
        }
        if (options.getPlotOptions().getPlotOptions(chartType) == null) {
            options.getPlotOptions().setPlotOptions(new PlotOptions(), chartType);
        }
        if (options.getPlotOptions().getPlotOptions(chartType).getPoint() == null) {
            options.getPlotOptions().getPlotOptions(chartType).setPoint(new PointOptions());
        }
        if (options.getPlotOptions().getPlotOptions(chartType).getPoint().getEvents() == null) {
            options.getPlotOptions().getPlotOptions(chartType).getPoint().setEvents(new Events());
        }
        options.getPlotOptions().getPlotOptions(chartType).getPoint().getEvents().setClick((Function)new DrilldownFunction(this.getDrilldownArrayName(this.component)));
    }

    private String getDrilldownArrayName(Component component) {
        return component.getMarkupId() + "_" + JS_DRILLDOWN_ARRAY_NAME;
    }
}

