/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts;

import com.googlecode.wickedcharts.JavaScriptResourceRegistry;
import com.googlecode.wickedcharts.highcharts.Chart;
import com.googlecode.wickedcharts.highcharts.Wicket15JsonRendererFactory;
import com.googlecode.wickedcharts.highcharts.jackson.JsonRenderer;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.drilldown.Wicket15DrilldownProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.OptionsProcessorContext;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.resource.ResourceReference;

public class ChartBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final Chart chart;

    public ChartBehavior(Chart container) {
        this.chart = container;
    }

    private void addTheme(IHeaderResponse response, JsonRenderer renderer) {
        if (this.chart.getTheme() != null) {
            response.renderOnDomReadyJavaScript(MessageFormat.format("Highcharts.setOptions({0});", renderer.toJson((Object)this.chart.getTheme())));
        } else if (this.chart.getThemeUrl() != null) {
            response.renderJavaScriptReference(this.chart.getThemeUrl());
        } else if (this.chart.getThemeReference() != null) {
            response.renderJavaScriptReference((ResourceReference)this.chart.getThemeReference());
        }
    }

    protected void includeChartJavascript(IHeaderResponse response, Options options, JsonRenderer renderer, String markupId) {
        String chartVarname = markupId;
        String optionsVarname = markupId + "Options";
        response.renderOnDomReadyJavaScript(MessageFormat.format("var {0} = {1};var {2} = new Highcharts.Chart({0});", optionsVarname, renderer.toJson((Object)options), chartVarname));
    }

    private void includeJavascriptDependencies(IHeaderResponse response, Options options) {
        JavaScriptResourceRegistry.getInstance().getJQueryEntry().addToHeaderResponse(response);
        JavaScriptResourceRegistry.getInstance().getHighchartsEntry().addToHeaderResponse(response);
        if (this.needsExporting(options)) {
            JavaScriptResourceRegistry.getInstance().getHighchartsExportingEntry().addToHeaderResponse(response);
        }
        if (this.needsMore(options)) {
            JavaScriptResourceRegistry.getInstance().getHighchartsMoreEntry().addToHeaderResponse(response);
        }
    }

    private boolean needsExporting(Options options) {
        return options.getExporting() == null || options.getExporting().getEnabled() != null && options.getExporting().getEnabled() != false;
    }

    private boolean needsMore(Options options) {
        return options.getChartOptions() != null && options.getChartOptions().getPolar() != null && options.getChartOptions().getPolar() != false;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        component.setOutputMarkupId(true);
        Options options = this.chart.getOptions();
        String id = component.getMarkupId();
        OptionsUtil.getInstance().setRenderTo(options, id);
        JsonRenderer renderer = Wicket15JsonRendererFactory.getInstance().getRenderer();
        this.includeJavascriptDependencies(response, options);
        this.addTheme(response, renderer);
        OptionsProcessorContext context = new OptionsProcessorContext();
        Wicket15DrilldownProcessor drilldownProcessor = new Wicket15DrilldownProcessor(component, response);
        drilldownProcessor.processOptions(options, context);
        this.includeChartJavascript(response, options, renderer, id);
    }
}

