/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket15;

import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.resource.ResourceReference;

public class JavaScriptResourceRegistry {
    public static final String DEFAULT_JQUERY_URL = "https://ajax.googleapis.com/ajax/libs/jquery/1.8.0/jquery.min.js";
    public static final String DEFAULT_HIGHCHARTS_URL = "http://code.highcharts.com/3.0.2/highcharts.js";
    public static final String DEFAULT_HIGHCHARTS_MORE_URL = "http://code.highcharts.com/3.0.2/highcharts-more.js";
    public static final String DEFAULT_HIGHCHARTS_EXPORTING_URL = "http://code.highcharts.com/3.0.2/modules/exporting.js";
    private RegistryEntry jqueryEntry = new RegistryEntry("https://ajax.googleapis.com/ajax/libs/jquery/1.8.0/jquery.min.js");
    private RegistryEntry highchartsEntry = new RegistryEntry("http://code.highcharts.com/3.0.2/highcharts.js");
    private RegistryEntry highchartsExportingEntry = new RegistryEntry("http://code.highcharts.com/3.0.2/modules/exporting.js");
    private RegistryEntry highchartsMoreEntry = new RegistryEntry("http://code.highcharts.com/3.0.2/highcharts-more.js");
    private static JavaScriptResourceRegistry INSTANCE;

    public static JavaScriptResourceRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JavaScriptResourceRegistry();
        }
        return INSTANCE;
    }

    private JavaScriptResourceRegistry() {
    }

    public RegistryEntry getHighchartsEntry() {
        return this.highchartsEntry;
    }

    public RegistryEntry getHighchartsExportingEntry() {
        return this.highchartsExportingEntry;
    }

    public RegistryEntry getHighchartsMoreEntry() {
        return this.highchartsMoreEntry;
    }

    public RegistryEntry getJQueryEntry() {
        return this.jqueryEntry;
    }

    public void setHighchartsExportingReference(ResourceReference reference) {
        this.highchartsExportingEntry = new RegistryEntry(reference);
    }

    public void setHighchartsExportingReference(String url) {
        this.highchartsExportingEntry = new RegistryEntry(url);
    }

    public void setHighchartsMoreReference(ResourceReference reference) {
        this.highchartsMoreEntry = new RegistryEntry(reference);
    }

    public void setHighchartsMoreReference(String url) {
        this.highchartsMoreEntry = new RegistryEntry(url);
    }

    public void setHighchartsReference(ResourceReference reference) {
        this.highchartsEntry = new RegistryEntry(reference);
    }

    public void setHighchartsReference(String url) {
        this.highchartsEntry = new RegistryEntry(url);
    }

    public void setJQueryReference(ResourceReference reference) {
        this.jqueryEntry = new RegistryEntry(reference);
    }

    public void setJQueryReference(String url) {
        this.jqueryEntry = new RegistryEntry(url);
    }

    public class RegistryEntry {
        private String url;
        private ResourceReference reference;

        public RegistryEntry(ResourceReference reference) {
            this.reference = reference;
        }

        public RegistryEntry(String url) {
            this.url = url;
        }

        public void addToHeaderResponse(IHeaderResponse response) {
            if (this.url != null) {
                response.renderJavaScriptReference(this.url);
            } else if (this.reference != null) {
                response.renderJavaScriptReference(this.reference);
            } else {
                throw new IllegalStateException("A RegistryEntry must have at least a non-null url or a non-null reference!");
            }
        }
    }
}

