/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket15.highcharts.features.basic;

import com.googlecode.wickedcharts.highcharts.jackson.JsonRenderer;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.processing.Feature;
import com.googlecode.wickedcharts.highcharts.options.processing.FeatureCheckingOptionsProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.OptionsProcessorContext;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import com.googlecode.wickedcharts.wicket15.JavaScriptResourceRegistry;
import com.googlecode.wickedcharts.wicket15.highcharts.Chart;
import com.googlecode.wickedcharts.wicket15.highcharts.JsonRendererFactory;
import com.googlecode.wickedcharts.wicket15.highcharts.features.drilldown.DrilldownProcessor;
import com.googlecode.wickedcharts.wicket15.highcharts.features.global.GlobalProcessor;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.resource.ResourceReference;

public class ChartBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final Chart chart;
    private static final Feature[] SUPPORTED_FEATURES = new Feature[]{Feature.DRILLDOWN, Feature.GLOBAL};

    public ChartBehavior(Chart container) {
        this.chart = container;
    }

    private void addTheme(IHeaderResponse response, JsonRenderer renderer) {
        if (this.chart.getTheme() != null) {
            response.renderOnDomReadyJavaScript(MessageFormat.format("Highcharts.setOptions({0});", renderer.toJson((Object)this.chart.getTheme())));
        } else if (this.chart.getThemeUrl() != null) {
            response.renderJavaScriptReference(this.chart.getThemeUrl());
        } else if (this.chart.getThemeReference() != null) {
            response.renderJavaScriptReference((ResourceReference)this.chart.getThemeReference());
        }
    }

    protected void includeChartJavascript(IHeaderResponse response, Options options, JsonRenderer renderer, String markupId) {
        String chartVarname = markupId;
        String optionsVarname = markupId + "Options";
        response.renderOnDomReadyJavaScript(MessageFormat.format("var {0} = {1};var {2} = new Highcharts.Chart({0});", optionsVarname, renderer.toJson((Object)options), chartVarname));
    }

    private void includeJavascriptDependencies(IHeaderResponse response, Options options) {
        JavaScriptResourceRegistry.getInstance().getJQueryEntry().addToHeaderResponse(response);
        JavaScriptResourceRegistry.getInstance().getHighchartsEntry().addToHeaderResponse(response);
        if (OptionsUtil.needsExportingJs((Options)options)) {
            JavaScriptResourceRegistry.getInstance().getHighchartsExportingEntry().addToHeaderResponse(response);
        }
        if (OptionsUtil.needsHighchartsMoreJs((Options)options)) {
            JavaScriptResourceRegistry.getInstance().getHighchartsMoreEntry().addToHeaderResponse(response);
        }
        if (OptionsUtil.needsFunnelJs((Options)options)) {
            JavaScriptResourceRegistry.getInstance().getFunnelEntry().addToHeaderResponse(response);
        }
        if (OptionsUtil.needsHeatmapJs((Options)options)) {
            JavaScriptResourceRegistry.getInstance().getHeatmapEntry().addToHeaderResponse(response);
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        component.setOutputMarkupId(true);
        Options options = this.chart.getOptions();
        String id = component.getMarkupId();
        OptionsUtil.getInstance().setRenderTo(options, id);
        JsonRenderer renderer = JsonRendererFactory.getInstance().getRenderer();
        this.includeJavascriptDependencies(response, options);
        this.addTheme(response, renderer);
        OptionsProcessorContext context = new OptionsProcessorContext(options);
        FeatureCheckingOptionsProcessor featureProcessor = new FeatureCheckingOptionsProcessor(SUPPORTED_FEATURES);
        featureProcessor.processOptions(this.chart.getOptions(), context);
        DrilldownProcessor drilldownProcessor = new DrilldownProcessor(component, response);
        drilldownProcessor.processOptions(options, context);
        GlobalProcessor globalProcessor = new GlobalProcessor(response);
        globalProcessor.processOptions(options, context);
        this.includeChartJavascript(response, options, renderer, id);
    }
}

