/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts;

import com.googlecode.wickedcharts.highcharts.ChartBehavior;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.theme.Theme;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.request.resource.JavaScriptResourceReference;

public class Chart
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private Options options;
    private Theme theme;
    private JavaScriptResourceReference themeReference;
    private String themeUrl;

    public Chart(String id, Options options) {
        super(id);
        this.init(options, null);
    }

    public Chart(String id, Options options, Theme theme) {
        super(id);
        this.init(options, theme);
    }

    public Options getOptions() {
        return this.options;
    }

    public Theme getTheme() {
        return this.theme;
    }

    public JavaScriptResourceReference getThemeReference() {
        return this.themeReference;
    }

    public String getThemeUrl() {
        return this.themeUrl;
    }

    private void init(Options options, Theme theme) {
        this.options = options;
        this.setTheme(theme);
        this.setOutputMarkupId(true);
        this.add(new Behavior[]{new ChartBehavior(this)});
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public void setTheme(JavaScriptResourceReference theme) {
        if (this.theme != null || this.themeUrl != null) {
            throw new IllegalStateException("A theme can only be defined once. Calling different setTheme methods is not allowed!");
        }
        this.themeReference = theme;
    }

    public void setTheme(String themeUrl) {
        if (this.themeReference != null || this.theme != null) {
            throw new IllegalStateException("A theme can only be defined once. Calling different setTheme methods is not allowed!");
        }
        this.themeUrl = themeUrl;
    }

    public void setTheme(Theme theme) {
        if (this.themeReference != null || this.themeUrl != null) {
            throw new IllegalStateException("A theme can only be defined once. Calling different setTheme methods is not allowed!");
        }
        this.theme = theme;
    }

    public void setThemeReference(JavaScriptResourceReference themeReference) {
        this.themeReference = themeReference;
    }

    public void setThemeUrl(String themeUrl) {
        this.themeUrl = themeUrl;
    }

    public String getJavaScriptVarName() {
        return this.getMarkupId() + "Var";
    }
}

