/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts;

import com.googlecode.wickedcharts.JavaScriptResourceRegistry;
import com.googlecode.wickedcharts.highcharts.Chart;
import com.googlecode.wickedcharts.highcharts.Wicket6JsonRendererFactory;
import com.googlecode.wickedcharts.highcharts.jackson.JsonRenderer;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.drilldown.Wicket6DrilldownProcessor;
import com.googlecode.wickedcharts.highcharts.options.livedata.Wicket6LiveDataProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.OptionsProcessorContext;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;

public class ChartBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final Chart chart;

    public ChartBehavior(Chart container) {
        this.chart = container;
    }

    private void addTheme(IHeaderResponse response, JsonRenderer renderer) {
        if (this.chart.getTheme() != null) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)MessageFormat.format("Highcharts.setOptions({0});", renderer.toJson((Object)this.chart.getTheme()))));
        } else if (this.chart.getThemeUrl() != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)this.chart.getThemeUrl()));
        } else if (this.chart.getThemeReference() != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)this.chart.getThemeReference()));
        }
    }

    protected void includeChartJavascript(IHeaderResponse response, Options options, JsonRenderer renderer, String markupId) {
        String chartVarname = this.chart.getJavaScriptVarName();
        String optionsVarname = markupId + "Options";
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)MessageFormat.format("var {0} = {1};window.{2} = new Highcharts.Chart({0});", optionsVarname, renderer.toJson((Object)options), chartVarname)));
    }

    private void includeJavascriptDependencies(IHeaderResponse response, Options options) {
        JavaScriptResourceRegistry.getInstance().getJQueryEntry().addToHeaderResponse(response);
        JavaScriptResourceRegistry.getInstance().getHighchartsEntry().addToHeaderResponse(response);
        if (this.needsExporting(options)) {
            JavaScriptResourceRegistry.getInstance().getHighchartsExportingEntry().addToHeaderResponse(response);
        }
        if (this.needsMore(options)) {
            JavaScriptResourceRegistry.getInstance().getHighchartsMoreEntry().addToHeaderResponse(response);
        }
    }

    private boolean needsExporting(Options options) {
        return options.getExporting() == null || options.getExporting().getEnabled() != null && options.getExporting().getEnabled() != false;
    }

    private boolean needsMore(Options options) {
        return options.getChartOptions() != null && options.getChartOptions().getPolar() != null && options.getChartOptions().getPolar() != false;
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        Wicket6LiveDataProcessor liveDataProcessor = new Wicket6LiveDataProcessor(component);
        liveDataProcessor.processOptions(this.chart.getOptions(), new OptionsProcessorContext());
    }

    public void renderHead(Component component, IHeaderResponse response) {
        component.setOutputMarkupId(true);
        Options options = this.chart.getOptions();
        String id = component.getMarkupId();
        OptionsUtil.getInstance().setRenderTo(options, id);
        JsonRenderer renderer = Wicket6JsonRendererFactory.getInstance().getRenderer();
        this.includeJavascriptDependencies(response, options);
        this.addTheme(response, renderer);
        OptionsProcessorContext context = new OptionsProcessorContext();
        Wicket6DrilldownProcessor drilldownProcessor = new Wicket6DrilldownProcessor(component, response);
        drilldownProcessor.processOptions(options, context);
        this.includeChartJavascript(response, options, renderer, id);
    }
}

