/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options.drilldown;

import com.googlecode.wickedcharts.highcharts.Wicket6JsonRendererFactory;
import com.googlecode.wickedcharts.highcharts.jackson.JsonRenderer;
import com.googlecode.wickedcharts.highcharts.options.Events;
import com.googlecode.wickedcharts.highcharts.options.Function;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.PlotOptions;
import com.googlecode.wickedcharts.highcharts.options.PlotOptionsChoice;
import com.googlecode.wickedcharts.highcharts.options.PointOptions;
import com.googlecode.wickedcharts.highcharts.options.SeriesType;
import com.googlecode.wickedcharts.highcharts.options.drilldown.DrilldownFunction;
import com.googlecode.wickedcharts.highcharts.options.drilldown.DrilldownPoint;
import com.googlecode.wickedcharts.highcharts.options.processing.IOptionsProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.OptionsProcessorContext;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import java.text.MessageFormat;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class Wicket6DrilldownProcessor
implements IOptionsProcessor {
    private static final String JS_DRILLDOWN_ARRAY_NAME = "drilldownOptions";
    private final Component component;
    private final IHeaderResponse response;

    public Wicket6DrilldownProcessor(Component component, IHeaderResponse response) {
        this.component = component;
        this.response = response;
    }

    public void processOptions(Options options, OptionsProcessorContext context) {
        this.collectDrilldownOptions(options, context);
        this.modifyDrilldownOptions(options, context);
        this.addDrilldownOptionsArray(context);
        this.addJavascriptDependencies(this.response);
    }

    private void modifyDrilldownOptions(Options options, OptionsProcessorContext context) {
        for (Options drilldownOptions : context.getDrilldownOptions()) {
            OptionsUtil.getInstance().copyRenderTo(options, drilldownOptions);
            this.addDrilldownFunction(drilldownOptions, context);
        }
    }

    private void collectDrilldownOptions(Options options, OptionsProcessorContext context) {
        List drilldownPoints = options.getMarkedForProcessing("DRILLDOWN");
        for (DrilldownPoint drilldownPoint : drilldownPoints) {
            Options drilldownOptions = drilldownPoint.getDrilldownOptions();
            if (!context.getDrilldownOptions().contains(drilldownOptions)) {
                context.getDrilldownOptions().add(drilldownOptions);
                this.collectDrilldownOptions(drilldownOptions, context);
            }
            drilldownPoint.setDrilldownOptionsIndex(Integer.valueOf(context.getDrilldownOptions().indexOf(drilldownOptions)));
        }
    }

    private void addDrilldownOptionsArray(OptionsProcessorContext context) {
        JsonRenderer renderer = Wicket6JsonRendererFactory.getInstance().getRenderer();
        this.response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)MessageFormat.format("var {0};", JS_DRILLDOWN_ARRAY_NAME), (String)"drilldownOptions-init"));
        this.response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)MessageFormat.format("{0} = {1};", this.getDrilldownArrayName(this.component), renderer.toJson((Object)context.getDrilldownOptions()))));
    }

    private void addJavascriptDependencies(IHeaderResponse headerResponse) {
        headerResponse.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(DrilldownFunction.class, "drilldown.js")));
    }

    private void addDrilldownFunction(Options options, OptionsProcessorContext context) {
        SeriesType chartType = options.getChartOptions().getType();
        if (options.getPlotOptions() == null) {
            options.setPlotOptions(new PlotOptionsChoice());
        }
        if (options.getPlotOptions().getPlotOptions(chartType) == null) {
            options.getPlotOptions().setPlotOptions(new PlotOptions(), chartType);
        }
        if (options.getPlotOptions().getPlotOptions(chartType).getPoint() == null) {
            options.getPlotOptions().getPlotOptions(chartType).setPoint(new PointOptions());
        }
        if (options.getPlotOptions().getPlotOptions(chartType).getPoint().getEvents() == null) {
            options.getPlotOptions().getPlotOptions(chartType).getPoint().setEvents(new Events());
        }
        options.getPlotOptions().getPlotOptions(chartType).getPoint().getEvents().setClick((Function)new DrilldownFunction(this.getDrilldownArrayName(this.component)));
    }

    private String getDrilldownArrayName(Component component) {
        return component.getMarkupId() + "_" + JS_DRILLDOWN_ARRAY_NAME;
    }
}

