/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.options.livedata;

import com.googlecode.wickedcharts.highcharts.options.Function;
import com.googlecode.wickedcharts.highcharts.options.IProcessableOption;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.livedata.LiveDataSeries;
import com.googlecode.wickedcharts.highcharts.options.livedata.Wicket6LiveDataAjaxBehavior;
import com.googlecode.wickedcharts.highcharts.options.livedata.Wicket6LiveDataFunction;
import com.googlecode.wickedcharts.highcharts.options.processing.IOptionsProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.OptionsProcessorContext;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;

public class Wicket6LiveDataProcessor
implements IOptionsProcessor {
    private final Component component;

    public Wicket6LiveDataProcessor(Component component) {
        this.component = component;
    }

    public void processOptions(Options options, OptionsProcessorContext context) {
        List processables = options.getMarkedForProcessing("LIVEUPDATE");
        for (IProcessableOption processable : processables) {
            LiveDataSeries series = (LiveDataSeries)processable;
            Wicket6LiveDataAjaxBehavior behavior = this.getBehaviorFromComponent(this.component);
            if (behavior == null) {
                behavior = new Wicket6LiveDataAjaxBehavior(series);
                this.component.add(new Behavior[]{behavior});
            }
            Wicket6LiveDataFunction function = new Wicket6LiveDataFunction(behavior);
            OptionsUtil.getInstance().setChartEventsLoad(options, (Function)function);
        }
    }

    private Wicket6LiveDataAjaxBehavior getBehaviorFromComponent(Component component) {
        List behaviors = component.getBehaviors(Wicket6LiveDataAjaxBehavior.class);
        if (behaviors.size() > 1) {
            throw new IllegalStateException("Only one " + Wicket6LiveDataAjaxBehavior.class.getSimpleName() + " can be active per component!");
        }
        if (behaviors.size() == 1) {
            ((Wicket6LiveDataAjaxBehavior)((Object)behaviors.get(0))).reset();
            return (Wicket6LiveDataAjaxBehavior)((Object)behaviors.get(0));
        }
        return null;
    }
}

