/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket6.highcharts.features.interaction;

import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.interaction.InteractionEvent;
import com.googlecode.wickedcharts.highcharts.options.series.Point;
import com.googlecode.wickedcharts.highcharts.options.series.Series;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import com.googlecode.wickedcharts.wicket6.highcharts.Chart;
import com.googlecode.wickedcharts.wicket6.highcharts.features.livedata.LiveDataAjaxBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValue;

public abstract class InteractionBehavior
extends AbstractDefaultAjaxBehavior {
    private static final String SELECTED_POINT_PLACEHOLDER = "SELECTED_POINT_PLACEHOLDER";
    private static final String SELECTED_SERIES_PLACEHOLDER = "SELECTED_SERIES_PLACEHOLDER";
    private static final String SELECTED_POINT = "selectedPoint";
    private static final String SELECTED_SERIES = "selectedSeries";

    protected void respond(AjaxRequestTarget target) {
        StringValue selectedSeriesValue;
        RequestCycle cycle = RequestCycle.get();
        WebRequest webRequest = (WebRequest)cycle.getRequest();
        Chart chart = (Chart)this.getComponent();
        Options options = chart.getOptions();
        InteractionEvent event = new InteractionEvent();
        StringValue selectedPointValue = webRequest.getQueryParameters().getParameterValue(SELECTED_POINT);
        if (selectedPointValue != null && !"".equals(selectedPointValue.toString())) {
            Integer selectedPoint = selectedPointValue.toInteger();
            Point point = OptionsUtil.getPointWithWickedChartsId((Options)options, (int)selectedPoint);
            event.setSelectedPoint(point);
        }
        if ((selectedSeriesValue = webRequest.getQueryParameters().getParameterValue(SELECTED_SERIES)) != null && !"".equals(selectedSeriesValue.toString())) {
            Integer selectedSeries = selectedSeriesValue.toInteger();
            Series series = OptionsUtil.getSeriesWithWickedChartsId((Options)options, (int)selectedSeries);
            event.setSelectedSeries(series);
        }
        event.setSelectedChart(options);
        this.onEvent(event, target);
    }

    public abstract void onEvent(InteractionEvent var1, AjaxRequestTarget var2);

    protected void onBind() {
        super.onBind();
        if (!(this.getComponent() instanceof Chart)) {
            throw new IllegalStateException(LiveDataAjaxBehavior.class.getSimpleName() + " can only be bound to components of type " + Chart.class.getSimpleName() + ".");
        }
    }

    public CharSequence getCallbackScript() {
        String script = super.getCallbackScript().toString();
        script = script.replace("\"SELECTED_POINT_PLACEHOLDER\"", SELECTED_POINT);
        script = script.replace("\"SELECTED_SERIES_PLACEHOLDER\"", SELECTED_SERIES);
        return script;
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        attributes.getExtraParameters().put(SELECTED_SERIES, SELECTED_SERIES_PLACEHOLDER);
        attributes.getExtraParameters().put(SELECTED_POINT, SELECTED_POINT_PLACEHOLDER);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(InteractionBehavior.class, "InteractionBehavior.js")));
    }
}

