/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket6.highcharts.features.livedata;

import com.googlecode.wickedcharts.highcharts.options.Function;
import com.googlecode.wickedcharts.highcharts.options.IProcessableOption;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.livedata.LiveDataSeries;
import com.googlecode.wickedcharts.highcharts.options.processing.IOptionsProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.OptionsProcessorContext;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import com.googlecode.wickedcharts.wicket6.highcharts.features.livedata.LiveDataAjaxBehavior;
import com.googlecode.wickedcharts.wicket6.highcharts.features.livedata.LiveDataFunction;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;

public class LiveDataProcessor
implements IOptionsProcessor {
    private final Component component;

    public LiveDataProcessor(Component component) {
        this.component = component;
    }

    public void processOptions(Options options, OptionsProcessorContext context) {
        List processables = options.getMarkedForProcessing("LIVEUPDATE");
        for (IProcessableOption processable : processables) {
            LiveDataSeries series = (LiveDataSeries)processable;
            LiveDataAjaxBehavior behavior = this.getBehaviorFromComponent(this.component);
            if (behavior == null) {
                behavior = new LiveDataAjaxBehavior(series);
                this.component.add(new Behavior[]{behavior});
            }
            LiveDataFunction function = new LiveDataFunction(behavior);
            OptionsUtil.getInstance().setChartEventsLoad(options, (Function)function);
        }
    }

    private LiveDataAjaxBehavior getBehaviorFromComponent(Component component) {
        List behaviors = component.getBehaviors(LiveDataAjaxBehavior.class);
        if (behaviors.size() > 1) {
            throw new IllegalStateException("Only one " + LiveDataAjaxBehavior.class.getSimpleName() + " can be active per component!");
        }
        if (behaviors.size() == 1) {
            ((LiveDataAjaxBehavior)((Object)behaviors.get(0))).reset();
            return (LiveDataAjaxBehavior)((Object)behaviors.get(0));
        }
        return null;
    }
}

