/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket6.highcharts.features.livedata;

import com.googlecode.wickedcharts.highcharts.jackson.JsonRenderer;
import com.googlecode.wickedcharts.highcharts.options.livedata.LiveDataSeries;
import com.googlecode.wickedcharts.highcharts.options.series.Point;
import com.googlecode.wickedcharts.wicket6.JavaScriptExpressionSendingAjaxBehavior;
import com.googlecode.wickedcharts.wicket6.highcharts.Chart;
import com.googlecode.wickedcharts.wicket6.highcharts.JsonRendererFactory;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;

public class LiveDataAjaxBehavior
extends JavaScriptExpressionSendingAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final LiveDataSeries series;
    private boolean firstRendering = true;

    public LiveDataAjaxBehavior(LiveDataSeries series) {
        this.series = series;
    }

    protected void respond(AjaxRequestTarget target) {
        Point point = this.series.update(this.createJavascriptParameters());
        if (point != null) {
            JsonRenderer renderer = JsonRendererFactory.getInstance().getRenderer();
            String jsonPoint = renderer.toJson((Object)point);
            String javaScript = "var chartVarName = " + ((Chart)this.getComponent()).getJavaScriptVarName() + ";\n";
            javaScript = javaScript + "var seriesIndex = 0;\n";
            javaScript = javaScript + "eval(chartVarName).series[seriesIndex].addPoint(" + jsonPoint + ", true, true);\n";
            target.appendJavaScript((CharSequence)javaScript);
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (this.firstRendering) {
            response.render(this.getIntervalDeclarationHeaderItem());
            this.firstRendering = false;
        } else {
            response.render(this.getClearIntervalHeaderItem());
        }
    }

    private HeaderItem getClearIntervalHeaderItem() {
        String varName = this.getIntervalJavaScriptVarName();
        String javaScript = MessageFormat.format("if(!(typeof {0} === \"undefined\"))'{'\nclearInterval({0});\n'}'", varName);
        return OnDomReadyHeaderItem.forScript((CharSequence)javaScript);
    }

    private HeaderItem getIntervalDeclarationHeaderItem() {
        String varName = this.getIntervalJavaScriptVarName();
        String javaScript = MessageFormat.format("var {0};", varName);
        return JavaScriptHeaderItem.forScript((CharSequence)javaScript, (String)(varName + "-declaration"));
    }

    protected String getIntervalJavaScriptVarName() {
        return this.getComponent().getMarkupId() + "SeriesInterval";
    }

    protected void reset() {
        this.firstRendering = true;
    }

    public LiveDataSeries getSeries() {
        return this.series;
    }

    protected void onBind() {
        super.onBind();
        if (!(this.getComponent() instanceof Chart)) {
            throw new IllegalStateException(LiveDataAjaxBehavior.class.getSimpleName() + " can only be bound to components of type " + Chart.class.getSimpleName() + ".");
        }
    }

    private LiveDataSeries.JavaScriptParameters createJavascriptParameters() {
        return new LiveDataSeries.JavaScriptParameters(){

            public String getParameterValue(String parameterName) {
                return LiveDataAjaxBehavior.this.getVariableValue(parameterName).toString();
            }
        };
    }
}

