/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket6.highcharts.features.selection;

import com.googlecode.wickedcharts.highcharts.jackson.JsonRenderer;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.interaction.Selection;
import com.googlecode.wickedcharts.highcharts.options.interaction.SelectionEvent;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import com.googlecode.wickedcharts.wicket6.JavaScriptExpressionSendingAjaxBehavior;
import com.googlecode.wickedcharts.wicket6.highcharts.Chart;
import com.googlecode.wickedcharts.wicket6.highcharts.JsonRendererFactory;
import com.googlecode.wickedcharts.wicket6.highcharts.features.livedata.LiveDataAjaxBehavior;
import com.googlecode.wickedcharts.wicket6.highcharts.features.selection.JsonSelection;
import com.googlecode.wickedcharts.wicket6.highcharts.features.selection.JsonSelectionEvent;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValue;

public abstract class SelectionBehavior
extends JavaScriptExpressionSendingAjaxBehavior {
    private static final String SELECTION_EVENT = "selectionEvent";

    public SelectionBehavior() {
        this.addJavaScriptValue(SELECTION_EVENT, "WickedCharts.Selection.selectionEventToJson(selectionEvent)");
    }

    protected void respond(AjaxRequestTarget target) {
        Chart chart = (Chart)this.getComponent();
        Options options = chart.getOptions();
        SelectionEvent event = new SelectionEvent();
        StringValue selectionEventJson = this.getVariableValue(SELECTION_EVENT);
        if (selectionEventJson != null && !"".equals(selectionEventJson.toString())) {
            Selection selection;
            JsonRenderer renderer = JsonRendererFactory.getInstance().getRenderer();
            JsonSelectionEvent jsonEvent = (JsonSelectionEvent)renderer.fromJson(selectionEventJson.toString(), JsonSelectionEvent.class);
            for (JsonSelection jsonSelection : jsonEvent.getxAxes()) {
                selection = this.mapJsonSelection(options, jsonSelection);
                event.getxAxes().add(selection);
            }
            for (JsonSelection jsonSelection : jsonEvent.getyAxes()) {
                selection = this.mapJsonSelection(options, jsonSelection);
                event.getyAxes().add(selection);
            }
        }
        this.onSelection(event, target);
    }

    private Selection mapJsonSelection(Options options, JsonSelection jsonSelection) {
        Selection selection = new Selection();
        selection.setMax(jsonSelection.getMax());
        selection.setMin(jsonSelection.getMin());
        selection.setAxis(OptionsUtil.getAxisWithWickedChartsId((Options)options, (int)jsonSelection.getWickedChartsId()));
        return selection;
    }

    public abstract void onSelection(SelectionEvent var1, AjaxRequestTarget var2);

    protected void onBind() {
        super.onBind();
        if (!(this.getComponent() instanceof Chart)) {
            throw new IllegalStateException(LiveDataAjaxBehavior.class.getSimpleName() + " can only be bound to components of type " + Chart.class.getSimpleName() + ".");
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(SelectionBehavior.class, "SelectionBehavior.js")));
    }
}

