/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket6.highcharts.features.basic;

import com.googlecode.wickedcharts.highcharts.jackson.JsonRenderer;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.processing.Feature;
import com.googlecode.wickedcharts.highcharts.options.processing.FeatureCheckingOptionsProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.IdGeneratorProcessor;
import com.googlecode.wickedcharts.highcharts.options.processing.OptionsProcessorContext;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import com.googlecode.wickedcharts.wicket6.JavaScriptResourceRegistry;
import com.googlecode.wickedcharts.wicket6.highcharts.Chart;
import com.googlecode.wickedcharts.wicket6.highcharts.JsonRendererFactory;
import com.googlecode.wickedcharts.wicket6.highcharts.features.drilldown.DrilldownProcessor;
import com.googlecode.wickedcharts.wicket6.highcharts.features.global.GlobalProcessor;
import com.googlecode.wickedcharts.wicket6.highcharts.features.interaction.InteractionProcessor;
import com.googlecode.wickedcharts.wicket6.highcharts.features.livedata.LiveDataProcessor;
import com.googlecode.wickedcharts.wicket6.highcharts.features.selection.SelectionProcessor;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptReferenceHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;

public class ChartBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final Chart chart;
    private static final Feature[] SUPPORTED_FEATURES = new Feature[]{Feature.DRILLDOWN, Feature.GLOBAL, Feature.INTERACTION, Feature.LIVEDATA, Feature.SELECTION};

    public ChartBehavior(Chart container) {
        this.chart = container;
    }

    private void addTheme(IHeaderResponse response, JsonRenderer renderer) {
        if (this.chart.getTheme() != null) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)MessageFormat.format("Highcharts.setOptions({0});", renderer.toJson((Object)this.chart.getTheme()))));
        } else if (this.chart.getThemeUrl() != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forUrl((String)this.chart.getThemeUrl()));
        } else if (this.chart.getThemeReference() != null) {
            response.render((HeaderItem)JavaScriptReferenceHeaderItem.forReference((ResourceReference)this.chart.getThemeReference()));
        }
    }

    protected void includeChartJavascript(IHeaderResponse response, Options options, JsonRenderer renderer, String markupId) {
        String chartVarname = this.chart.getJavaScriptVarName();
        String optionsVarname = markupId + "Options";
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)MessageFormat.format("var {0} = {1};window.{2} = new Highcharts.Chart({0});", optionsVarname, renderer.toJson((Object)options), chartVarname)));
    }

    private void includeJavascriptDependencies(IHeaderResponse response, Options options) {
        JavaScriptResourceRegistry.getInstance().getJQueryEntry().addToHeaderResponse(response);
        JavaScriptResourceRegistry.getInstance().getHighchartsEntry().addToHeaderResponse(response);
        if (OptionsUtil.needsExportingJs((Options)options)) {
            JavaScriptResourceRegistry.getInstance().getHighchartsExportingEntry().addToHeaderResponse(response);
        }
        if (OptionsUtil.needsHighchartsMoreJs((Options)options)) {
            JavaScriptResourceRegistry.getInstance().getHighchartsMoreEntry().addToHeaderResponse(response);
        }
        if (OptionsUtil.needsFunnelJs((Options)options)) {
            JavaScriptResourceRegistry.getInstance().getFunnelEntry().addToHeaderResponse(response);
        }
        if (OptionsUtil.needsHeatmapJs((Options)options)) {
            JavaScriptResourceRegistry.getInstance().getHeatmapEntry().addToHeaderResponse(response);
        }
    }

    public void onConfigure(Component component) {
        super.onConfigure(component);
        OptionsProcessorContext context = new OptionsProcessorContext(this.chart.getOptions());
        FeatureCheckingOptionsProcessor featureProcessor = new FeatureCheckingOptionsProcessor(SUPPORTED_FEATURES);
        featureProcessor.processOptions(this.chart.getOptions(), context);
        IdGeneratorProcessor idProcessor = new IdGeneratorProcessor();
        idProcessor.processOptions(this.chart.getOptions(), context);
        LiveDataProcessor liveDataProcessor = new LiveDataProcessor(component);
        liveDataProcessor.processOptions(this.chart.getOptions(), context);
        InteractionProcessor interactionProcessor = new InteractionProcessor(this.chart);
        interactionProcessor.processOptions(this.chart.getOptions(), context);
        SelectionProcessor selectionProcessor = new SelectionProcessor(this.chart);
        selectionProcessor.processOptions(this.chart.getOptions(), context);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        component.setOutputMarkupId(true);
        Options options = this.chart.getOptions();
        String id = component.getMarkupId();
        OptionsUtil.getInstance().setRenderTo(options, id);
        JsonRenderer renderer = JsonRendererFactory.getInstance().getRenderer();
        this.includeJavascriptDependencies(response, options);
        this.addTheme(response, renderer);
        OptionsProcessorContext context = new OptionsProcessorContext(options);
        DrilldownProcessor drilldownProcessor = new DrilldownProcessor(component, response);
        drilldownProcessor.processOptions(options, context);
        GlobalProcessor globalProcessor = new GlobalProcessor(response);
        globalProcessor.processOptions(options, context);
        this.includeChartJavascript(response, options, renderer, id);
    }
}

