/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket7;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.util.string.StringValue;

public abstract class JavaScriptExpressionSendingAjaxBehavior
extends AbstractDefaultAjaxBehavior {
    private final Map<String, String> javascriptExpressions = new HashMap<String, String>();

    protected StringValue getVariableValue(String parameterName) {
        RequestCycle cycle = RequestCycle.get();
        WebRequest webRequest = (WebRequest)cycle.getRequest();
        StringValue value = webRequest.getRequestParameters().getParameterValue(parameterName);
        return value;
    }

    public CharSequence getCallbackScript() {
        String script = super.getCallbackScript().toString();
        for (Map.Entry<String, String> entry : this.javascriptExpressions.entrySet()) {
            String expression = entry.getValue();
            script = script.replace("\"" + expression + "\"", expression);
        }
        return script;
    }

    public void addJavaScriptValue(String parameterName, String javascriptExpression) {
        this.javascriptExpressions.put(parameterName, javascriptExpression);
    }

    public void addJavaScriptValues(Map<String, String> parameterMap) {
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            String parameterName = entry.getKey();
            String parameterValue = entry.getValue();
            this.javascriptExpressions.put(parameterName, parameterValue);
        }
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        for (Map.Entry<String, String> entry : this.javascriptExpressions.entrySet()) {
            String parameterName = entry.getKey();
            String parameterValue = entry.getValue();
            attributes.getExtraParameters().put(parameterName, parameterValue);
        }
    }
}

