/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket7.highcharts.features.interaction;

import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.interaction.InteractionEvent;
import com.googlecode.wickedcharts.highcharts.options.series.Point;
import com.googlecode.wickedcharts.highcharts.options.series.Series;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import com.googlecode.wickedcharts.wicket7.JavaScriptExpressionSendingAjaxBehavior;
import com.googlecode.wickedcharts.wicket7.highcharts.Chart;
import com.googlecode.wickedcharts.wicket7.highcharts.features.livedata.LiveDataAjaxBehavior;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValue;

public abstract class InteractionBehavior
extends JavaScriptExpressionSendingAjaxBehavior {
    private static final String SELECTED_POINT = "selectedPoint";
    private static final String SELECTED_SERIES = "selectedSeries";

    public InteractionBehavior() {
        this.addJavaScriptValue(SELECTED_SERIES, "WickedCharts.Interaction.getSelectedSeries(this)");
        this.addJavaScriptValue(SELECTED_POINT, "WickedCharts.Interaction.getSelectedPoint(this)");
    }

    protected void respond(AjaxRequestTarget target) {
        StringValue selectedSeriesValue;
        Chart chart = (Chart)this.getComponent();
        Options options = chart.getOptions();
        InteractionEvent event = new InteractionEvent();
        event.setJavascriptChartName(chart.getJavaScriptVarName());
        StringValue selectedPointValue = this.getVariableValue(SELECTED_POINT);
        if (selectedPointValue != null && !"".equals(selectedPointValue.toString())) {
            Integer selectedPoint = selectedPointValue.toInteger();
            Point point = OptionsUtil.getPointWithWickedChartsId((Options)options, (int)selectedPoint);
            event.setSelectedPoint(point);
        }
        if ((selectedSeriesValue = this.getVariableValue(SELECTED_SERIES)) != null && !"".equals(selectedSeriesValue.toString())) {
            Integer selectedSeries = selectedSeriesValue.toInteger();
            Series series = OptionsUtil.getSeriesWithWickedChartsId((Options)options, (int)selectedSeries);
            event.setSelectedSeries(series);
        }
        event.setSelectedChart(options);
        this.onEvent(event, target);
    }

    public abstract void onEvent(InteractionEvent var1, AjaxRequestTarget var2);

    protected void onBind() {
        super.onBind();
        if (!(this.getComponent() instanceof Chart)) {
            throw new IllegalStateException(LiveDataAjaxBehavior.class.getSimpleName() + " can only be bound to components of type " + Chart.class.getSimpleName() + ".");
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(InteractionBehavior.class, "InteractionBehavior.js")));
    }
}

