/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.wicket7.highcharts.features.livedata;

import com.googlecode.wickedcharts.highcharts.jackson.JsonRenderer;
import com.googlecode.wickedcharts.highcharts.options.Options;
import com.googlecode.wickedcharts.highcharts.options.livedata.JavaScriptParameters;
import com.googlecode.wickedcharts.highcharts.options.livedata.LiveDataSeries;
import com.googlecode.wickedcharts.highcharts.options.livedata.LiveDataUpdateEvent;
import com.googlecode.wickedcharts.highcharts.options.series.Point;
import com.googlecode.wickedcharts.highcharts.options.util.OptionsUtil;
import com.googlecode.wickedcharts.wicket7.JavaScriptExpressionSendingAjaxBehavior;
import com.googlecode.wickedcharts.wicket7.highcharts.Chart;
import com.googlecode.wickedcharts.wicket7.highcharts.JsonRendererFactory;
import com.googlecode.wickedcharts.wicket7.highcharts.features.livedata.WicketLiveDataUpdateEvent;
import java.text.MessageFormat;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;

public class LiveDataAjaxBehavior
extends JavaScriptExpressionSendingAjaxBehavior {
    private static final long serialVersionUID = 1L;
    private final LiveDataSeries series;
    private boolean firstRendering = true;

    public LiveDataAjaxBehavior(LiveDataSeries series) {
        this.series = series;
    }

    protected void respond(AjaxRequestTarget target) {
        Chart chart = (Chart)this.getComponent();
        int seriesIndex = OptionsUtil.getSeriesIndex((Options)chart.getOptions(), (int)this.series.getWickedChartsId());
        LiveDataUpdateEvent event = new LiveDataUpdateEvent();
        event.setJavascriptChartName(chart.getJavaScriptVarName());
        event.setParameters(this.createJavascriptParameters());
        WicketLiveDataUpdateEvent wicketEvent = new WicketLiveDataUpdateEvent(target, event);
        Point point = this.series.update((LiveDataUpdateEvent)wicketEvent);
        if (point != null) {
            JsonRenderer renderer = JsonRendererFactory.getInstance().getRenderer();
            String jsonPoint = renderer.toJson((Object)point);
            String javaScript = "var chartVarName = " + ((Chart)this.getComponent()).getJavaScriptVarName() + ";\n";
            javaScript = javaScript + "var seriesIndex = " + seriesIndex + ";\n";
            javaScript = javaScript + "eval(chartVarName).series[seriesIndex].addPoint(" + jsonPoint + ", true, true);\n";
            target.appendJavaScript((CharSequence)javaScript);
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        if (this.firstRendering) {
            response.render(this.getIntervalDeclarationHeaderItem());
            this.firstRendering = false;
        } else {
            response.render(this.getClearIntervalHeaderItem());
        }
    }

    private HeaderItem getClearIntervalHeaderItem() {
        String varName = this.getIntervalJavaScriptVarName();
        String javaScript = MessageFormat.format("if(!(typeof {0} === \"undefined\"))'{'\nclearInterval({0});\n'}'", varName);
        return OnDomReadyHeaderItem.forScript((CharSequence)javaScript);
    }

    private HeaderItem getIntervalDeclarationHeaderItem() {
        String varName = this.getIntervalJavaScriptVarName();
        String javaScript = MessageFormat.format("var {0};", varName);
        return JavaScriptHeaderItem.forScript((CharSequence)javaScript, (String)(varName + "-declaration"));
    }

    protected String getIntervalJavaScriptVarName() {
        Chart chart = (Chart)this.getComponent();
        int seriesIndex = OptionsUtil.getSeriesIndex((Options)chart.getOptions(), (int)this.series.getWickedChartsId());
        return this.getComponent().getMarkupId() + "SeriesInterval" + seriesIndex;
    }

    protected void reset() {
        this.firstRendering = true;
    }

    public LiveDataSeries getSeries() {
        return this.series;
    }

    protected void onBind() {
        super.onBind();
        if (!(this.getComponent() instanceof Chart)) {
            throw new IllegalStateException(LiveDataAjaxBehavior.class.getSimpleName() + " can only be bound to components of type " + Chart.class.getSimpleName() + ".");
        }
    }

    private JavaScriptParameters createJavascriptParameters() {
        return new JavaScriptParameters(){

            public String getParameterValue(String parameterName) {
                return LiveDataAjaxBehavior.this.getVariableValue(parameterName).toString();
            }
        };
    }
}

