/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xremoting.core;

import com.googlecode.xremoting.core.exception.InitializationException;
import com.googlecode.xremoting.core.http.DefaultHttpConnectionFactory;
import com.googlecode.xremoting.core.http.HttpConnectionFactory;
import com.googlecode.xremoting.core.http.HttpRequester;
import com.googlecode.xremoting.core.invoking.XRemotingInvocationHandler;
import com.googlecode.xremoting.core.spi.Requester;
import com.googlecode.xremoting.core.spi.Serializer;
import com.googlecode.xremoting.core.utils.ClassLoaderUtils;
import com.googlecode.xremoting.core.xstream.XStreamSerializer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRemotingProxyFactory {
    protected Serializer serializer;
    protected Requester requester;

    public XRemotingProxyFactory(String url) {
        this.init(this.createDefaultRequester(url), (Serializer)null);
    }

    public XRemotingProxyFactory(Requester requester) {
        this.init(requester, (Serializer)null);
    }

    public XRemotingProxyFactory(Requester requester, String serializerClassName) {
        this.init(requester, serializerClassName, this.getDefaultClassLoader());
    }

    public XRemotingProxyFactory(Requester requester, String serializerClassName, ClassLoader spiClassLoader) {
        this.init(requester, serializerClassName, spiClassLoader);
    }

    public XRemotingProxyFactory(Requester requester, Class<? extends Serializer> serializerClass) {
        this.init(requester, serializerClass);
    }

    public XRemotingProxyFactory(Requester requester, Serializer serializer) {
        this.init(requester, serializer);
    }

    private void init(Requester requester, String serializerClassName, ClassLoader spiClassLoader) {
        Class<?> clazz;
        try {
            clazz = Class.forName(serializerClassName, true, spiClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException(e);
        }
        this.init(requester, clazz);
    }

    private void init(Requester requester, Class<? extends Serializer> serializerClass) {
        this.init(requester, this.createSerializer(serializerClass));
    }

    private void init(Requester requester, Serializer serializer) {
        this.requester = requester;
        if (serializer == null) {
            serializer = this.createDefaultSerializer();
        }
        this.serializer = serializer;
    }

    public Object create(Class<?> iface) {
        return this.create(iface, this.getDefaultClassLoader());
    }

    public Object create(Class<?>[] ifaces) {
        return this.create(ifaces, this.getDefaultClassLoader());
    }

    public Object create(Class<?> iface, ClassLoader proxyLoader) {
        return this.create(new Class[]{iface}, proxyLoader);
    }

    public Object create(Class<?>[] ifaces, ClassLoader proxyLoader) {
        return Proxy.newProxyInstance(proxyLoader, ifaces, (InvocationHandler)new XRemotingInvocationHandler(this.serializer, this.requester));
    }

    protected Serializer createSerializer(Class<? extends Serializer> serializerClass) {
        try {
            return serializerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new InitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new InitializationException(e);
        }
    }

    protected ClassLoader getDefaultClassLoader() {
        return ClassLoaderUtils.getDefaultClassLoader(this.getClass());
    }

    protected Serializer createDefaultSerializer() {
        return new XStreamSerializer();
    }

    protected Requester createDefaultRequester(String url) {
        HttpConnectionFactory httpConnectionFactory = this.createDefaultHttpConnectionFactory();
        return new HttpRequester(httpConnectionFactory, url);
    }

    protected HttpConnectionFactory createDefaultHttpConnectionFactory() {
        DefaultHttpConnectionFactory httpConnectionFactory = new DefaultHttpConnectionFactory();
        return httpConnectionFactory;
    }
}

