/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xremoting.core.commonshttpclient;

import com.googlecode.xremoting.core.spi.Request;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class CommonsHttpClientRequest
implements Request {
    private HttpClient httpClient;
    private PostMethod method;
    private ByteArrayOutputStream funnel = new ByteArrayOutputStream();
    private boolean committed = false;
    private OutputStream os = new FunnelOutputStream();
    private InputStream is;

    public CommonsHttpClientRequest(HttpClient httpClient, PostMethod method) {
        this.httpClient = httpClient;
        this.method = method;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public void commitRequest() throws IOException {
        this.checkNotCommitted();
        this.committed = true;
        this.method.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(this.funnel.toByteArray()));
        this.funnel = null;
        try {
            this.os.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.os = null;
        this.httpClient.executeMethod((HttpMethod)this.method);
        this.checkStatusCode(this.method);
        this.is = this.method.getResponseBodyAsStream();
    }

    protected void checkStatusCode(PostMethod method) throws IOException {
        if (method.getStatusCode() != 200) {
            throw new IOException("Wrong status code: 200 expected but got " + method.getStatusCode() + " (" + method.getStatusText() + ")");
        }
    }

    public InputStream getInputStream() throws IOException {
        this.checkCommitted();
        return this.is;
    }

    public void releaseRequest() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.os = null;
        }
        this.funnel = null;
        if (this.method != null) {
            this.method.releaseConnection();
        }
    }

    private void checkNotCommitted() {
        if (this.committed) {
            throw new IllegalStateException("Already committed!");
        }
    }

    private void checkCommitted() {
        if (!this.committed) {
            throw new IllegalStateException("Not yet committed!");
        }
    }

    private class FunnelOutputStream
    extends OutputStream {
        private FunnelOutputStream() {
        }

        public void write(int b) throws IOException {
            CommonsHttpClientRequest.this.checkNotCommitted();
            CommonsHttpClientRequest.this.funnel.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            CommonsHttpClientRequest.this.checkNotCommitted();
            CommonsHttpClientRequest.this.funnel.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            CommonsHttpClientRequest.this.checkNotCommitted();
            CommonsHttpClientRequest.this.funnel.write(b);
        }
    }
}

