/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xremoting.core.servlet;

import com.googlecode.xremoting.core.invoked.DefaultInvoker;
import com.googlecode.xremoting.core.invoked.InvocationRestriction;
import com.googlecode.xremoting.core.invoked.Invoker;
import com.googlecode.xremoting.core.invoked.ProxyInvokingHelper;
import com.googlecode.xremoting.core.spi.Serializer;
import com.googlecode.xremoting.core.utils.ClassLoaderUtils;
import com.googlecode.xremoting.core.xstream.XStreamSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XRemotingServlet
extends HttpServlet {
    private static final long serialVersionUID = 3625935027430412706L;
    private Serializer serializer;
    private Invoker invoker;
    private ProxyInvokingHelper invokingHelper;
    private InvocationRestriction restriction;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.serializer = this.createSerializer();
        this.invoker = this.createInvoker();
        this.invokingHelper = this.createInvokingHelper();
        this.doInit(config);
    }

    protected void doInit(ServletConfig config) throws ServletException {
        String interfacesString = config.getInitParameter("exposedInterfaces");
        if (interfacesString == null) {
            throw new ServletException("init-parameter called exposedInterfaces is required");
        }
        ClassLoader classLoader = this.getInterfacesClassLoader();
        ArrayList interfaces = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(interfacesString, "\t\n\r\f,");
        while (tokenizer.hasMoreTokens()) {
            Class<?> iface;
            String token = tokenizer.nextToken().trim();
            if (token.length() <= 0) continue;
            try {
                iface = Class.forName(token, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new ServletException((Throwable)e);
            }
            interfaces.add(iface);
        }
        this.restriction = this.createInvocationRestriction(interfaces.toArray(new Class[interfaces.size()]));
    }

    protected InvocationRestriction createInvocationRestriction(Class<?>[] interfaces) {
        return new InvocationRestriction(interfaces);
    }

    protected ClassLoader getInterfacesClassLoader() {
        return ClassLoaderUtils.getDefaultClassLoader(((Object)((Object)this)).getClass());
    }

    protected Serializer createSerializer() {
        return new XStreamSerializer();
    }

    protected Invoker createInvoker() {
        return new DefaultInvoker();
    }

    protected ProxyInvokingHelper createInvokingHelper() {
        return new ProxyInvokingHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletInputStream is = null;
        ServletOutputStream os = null;
        try {
            is = request.getInputStream();
            os = response.getOutputStream();
            this.beforeInvocation(request, response);
            try {
                this.invokingHelper.invoke(this.getTarget(), (InputStream)is, (OutputStream)os, this.serializer, this.invoker, this.restriction);
            }
            finally {
                this.afterInvocation(request, response);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    protected void beforeInvocation(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void afterInvocation(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected abstract Object getTarget();
}

