/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xremoting.core.xstream;

import com.googlecode.xremoting.core.message.Invocation;
import com.googlecode.xremoting.core.message.Result;
import com.googlecode.xremoting.core.message.Thrown;
import com.googlecode.xremoting.core.spi.SerializationException;
import com.googlecode.xremoting.core.spi.Serializer;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.BaseException;
import com.thoughtworks.xstream.io.StreamException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XStreamSerializer
implements Serializer {
    protected XStream xstream = this.createXStream();

    protected XStream createXStream() {
        XStream xs = new XStream();
        xs.alias("invocation", Invocation.class);
        xs.alias("result", Result.class);
        xs.alias("thrown", Thrown.class);
        return xs;
    }

    @Override
    public void serialize(Object object, OutputStream os) throws SerializationException, IOException {
        try {
            this.xstream.toXML(object, this.createWriter(os));
        }
        catch (StreamException e) {
            throw new IOException(e);
        }
        catch (BaseException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public <T> T deserialize(InputStream is) throws SerializationException, IOException {
        try {
            return (T)this.xstream.fromXML(this.createReader(is));
        }
        catch (BaseException e) {
            throw new SerializationException(e);
        }
    }

    protected Writer createWriter(OutputStream os) throws UnsupportedEncodingException {
        return new OutputStreamWriter(os, this.getDefaultCharset());
    }

    protected Reader createReader(InputStream is) throws UnsupportedEncodingException {
        return new InputStreamReader(is, this.getDefaultCharset());
    }

    protected String getDefaultCharset() {
        return "utf-8";
    }
}

