/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xremoting.spring;

import com.googlecode.xremoting.core.XRemotingProxyFactory;
import com.googlecode.xremoting.core.commonshttpclient.CommonsHttpClientRequester;
import com.googlecode.xremoting.core.commonshttpclient.HttpClientBuilder;
import com.googlecode.xremoting.core.exception.XRemotingException;
import com.googlecode.xremoting.core.http.DefaultHttpConnectionFactory;
import com.googlecode.xremoting.core.http.HttpConnectionFactory;
import com.googlecode.xremoting.core.http.HttpRequester;
import com.googlecode.xremoting.core.spi.Requester;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.httpclient.HttpClient;
import org.springframework.core.io.Resource;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class XRemotingClientInterceptor
extends UrlBasedRemoteAccessor
implements MethodInterceptor {
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Requester requester = null;
    private Object httpClient = null;
    private String proxyHost;
    private int proxyPort = -1;
    private String username;
    private String password;
    private boolean authPreemptive = true;
    private String basicAuthHost;
    private int basicAuthPort = -1;
    private URL trustKeyStoreUrl;
    private Resource trustKeyStoreResource;
    private URL keyStoreUrl;
    private Resource keyStoreResource;
    private String trustKeyStorePassword;
    private String keyStorePassword;
    private String sslHost;
    private int sslPort = 443;
    private String[] sslEnabledProtocols = null;
    private int connectionTimeout = 10000;
    private int soTimeout = 10000;
    private long connectionManagerTimeout = 10000L;
    private Object xremotingProxy;

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void setRequester(Requester requester) {
        this.requester = requester;
    }

    public void setHttpClient(Object httpClient) {
        this.httpClient = httpClient;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setAuthPreemptive(boolean authPreemptive) {
        this.authPreemptive = authPreemptive;
    }

    public void setBasicAuthHost(String basicAuthHost) {
        this.basicAuthHost = basicAuthHost;
    }

    public void setBasicAuthPort(int basicAuthPort) {
        this.basicAuthPort = basicAuthPort;
    }

    public void setTrustKeyStoreUrl(URL trustKeyStoreUrl) {
        this.trustKeyStoreUrl = trustKeyStoreUrl;
    }

    public void setTrustKeyStoreResource(Resource trustKeyStoreResource) {
        this.trustKeyStoreResource = trustKeyStoreResource;
    }

    public void setKeyStoreUrl(URL keyStoreUrl) {
        this.keyStoreUrl = keyStoreUrl;
    }

    public void setKeyStoreResource(Resource keyStoreResource) {
        this.keyStoreResource = keyStoreResource;
    }

    public void setTrustKeyStorePassword(String trustKeyStorePassword) {
        this.trustKeyStorePassword = trustKeyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setSslHost(String sslHost) {
        this.sslHost = sslHost;
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public void setSslEnabledProtocols(String[] sslEnabledProtocols) {
        this.sslEnabledProtocols = sslEnabledProtocols;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public void setConnectionManagerTimeout(long connectionManagerTimeout) {
        this.connectionManagerTimeout = connectionManagerTimeout;
    }

    protected final ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.getServiceInterface(), (String)"serviceInterface cannot be null");
        super.afterPropertiesSet();
        try {
            this.prepare();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void prepare() throws IOException {
        this.xremotingProxy = this.createXRemotingProxy(this.createProxyFactory());
    }

    protected XRemotingProxyFactory createProxyFactory() throws IOException {
        if (this.requester == null) {
            this.requester = this.createRequester();
        }
        return new XRemotingProxyFactory(this.requester);
    }

    protected Requester createRequester() throws IOException {
        if (this.username != null || this.trustKeyStoreResource != null || this.trustKeyStoreUrl != null || this.keyStoreResource != null || this.keyStoreUrl != null) {
            return this.createComplexRequester();
        }
        return this.createSimpleRequester();
    }

    protected Requester createSimpleRequester() {
        HttpConnectionFactory httpConnectionFactory = this.createHttpConnectionFactory();
        return new HttpRequester(httpConnectionFactory, this.getServiceUrl());
    }

    protected HttpConnectionFactory createHttpConnectionFactory() {
        return new DefaultHttpConnectionFactory();
    }

    protected Requester createComplexRequester() throws IOException {
        HttpClient httpClient = (HttpClient)this.httpClient;
        if (httpClient == null) {
            httpClient = this.createHttpClient();
        }
        return new CommonsHttpClientRequester(httpClient, this.getServiceUrl());
    }

    protected HttpClient createHttpClient() throws IOException {
        HttpClientBuilder builder = this.createAndConfigureHttpClientBuilder();
        return builder.build();
    }

    protected HttpClientBuilder createAndConfigureHttpClientBuilder() throws IOException {
        boolean useSsl;
        URL keystoreUrl;
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.proxyHost != null) {
            builder.proxyHost(this.proxyHost);
            if (this.proxyPort >= 0) {
                builder.proxyPort(this.proxyPort);
            }
        }
        if (this.username != null) {
            builder.basicAuth(this.username, this.password);
        }
        builder.authPreemprive(this.authPreemptive);
        if (this.basicAuthHost != null) {
            builder.basicAuthHost(this.basicAuthHost);
        }
        if (this.basicAuthPort >= 0) {
            builder.basicAuthPort(this.basicAuthPort);
        }
        Assert.isTrue((this.trustKeyStoreResource == null || this.trustKeyStoreUrl == null ? 1 : 0) != 0, (String)"trustKeyStoreResource and trustKeyStoreUrl cannot be defined at the same time");
        Assert.isTrue((this.keyStoreResource == null || this.keyStoreUrl == null ? 1 : 0) != 0, (String)"keyStoreResource and keyStoreUrl cannot be defined at the same time");
        URL truststoreUrl = this.trustKeyStoreUrl;
        if (truststoreUrl == null && this.trustKeyStoreResource != null) {
            truststoreUrl = this.trustKeyStoreResource.getURL();
        }
        if ((keystoreUrl = this.keyStoreUrl) == null && this.keyStoreResource != null) {
            keystoreUrl = this.keyStoreResource.getURL();
        }
        boolean bl = useSsl = truststoreUrl != null || keystoreUrl != null;
        if (useSsl) {
            Assert.isTrue((truststoreUrl == null || this.trustKeyStorePassword != null ? 1 : 0) != 0, (String)"trustKeyStorePassword cannot be null");
            Assert.isTrue((keystoreUrl == null || this.keyStorePassword != null ? 1 : 0) != 0, (String)"keyStorePassword cannot be null");
            Assert.notNull((Object)this.sslHost, (String)"sslHost cannot be null");
            builder.ssl(this.sslHost);
            builder.trustKeyStore(truststoreUrl, this.trustKeyStorePassword);
            builder.keyStore(keystoreUrl, this.keyStorePassword);
            builder.securePort(this.sslPort);
            builder.sslEnabledProtocols(this.sslEnabledProtocols);
        }
        builder.timeouts(this.connectionTimeout, this.soTimeout, this.connectionManagerTimeout);
        return builder;
    }

    protected Object createXRemotingProxy(XRemotingProxyFactory proxyFactory) {
        return proxyFactory.create(this.getServiceInterface(), this.getBeanClassLoader());
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.xremotingProxy == null) {
            throw new IllegalStateException("XRemotingClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        try {
            return invocation.getMethod().invoke(this.xremotingProxy, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof XRemotingException) {
                XRemotingException xre = (XRemotingException)ex.getTargetException();
                throw this.convertXRemotingAccessException(xre);
            }
            if (ex.getTargetException() instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utex = (UndeclaredThrowableException)ex.getTargetException();
                throw this.convertXRemotingAccessException(utex.getUndeclaredThrowable());
            }
            throw ex.getTargetException();
        }
        catch (Throwable ex) {
            throw new RemoteProxyFailureException("Failed to invoke XRemoting proxy for remote service [" + this.getServiceUrl() + "]", ex);
        }
    }

    protected RemoteAccessException convertXRemotingAccessException(Throwable ex) {
        if (ex instanceof ClassNotFoundException) {
            throw new RemoteAccessException("Cannot deserialize result from XRemoting remote service [" + this.getServiceUrl() + "]", ex);
        }
        throw new RemoteAccessException("Cannot access XRemoting remote service at [" + this.getServiceUrl() + "]", ex);
    }
}

