/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xremoting.spring;

import com.googlecode.xremoting.core.invoked.DefaultInvoker;
import com.googlecode.xremoting.core.invoked.InvocationRestriction;
import com.googlecode.xremoting.core.invoked.Invoker;
import com.googlecode.xremoting.core.invoked.ProxyInvokingHelper;
import com.googlecode.xremoting.core.spi.Serializer;
import com.googlecode.xremoting.core.utils.ClassLoaderUtils;
import com.googlecode.xremoting.core.xstream.XStreamSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRemotingExporter
extends RemoteExporter
implements InitializingBean {
    protected Serializer serializer;
    protected Class<? extends Serializer> serializerClass;
    protected String serializerClassName;
    protected ClassLoader serializerClassLoader;
    protected Invoker invoker;
    protected ProxyInvokingHelper invokingHelper;
    protected InvocationRestriction restriction;

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void setSerializerClass(Class<? extends Serializer> serializerClass) {
        this.serializerClass = serializerClass;
    }

    public void setSerializerClassName(String serializerClassName) {
        this.serializerClassName = serializerClassName;
    }

    public void setSerializerClassLoader(ClassLoader serializerClassLoader) {
        this.serializerClassLoader = serializerClassLoader;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getServiceInterface(), (String)"Service interface cannot be null");
        Assert.notNull((Object)this.getService(), (String)"Service interface cannot be null");
        int num = 0;
        if (this.serializer != null) {
            ++num;
        }
        if (this.serializerClass != null) {
            ++num;
        }
        if (this.serializerClassName != null) {
            ++num;
        }
        Assert.isTrue((num <= 1 ? 1 : 0) != 0, (String)"Maximum one of serializer, serializerClass and serializerClassName may be specified");
        if (this.serializer == null) {
            this.serializer = this.createSerializer();
        }
        if (this.invoker == null) {
            this.invoker = this.createDefaultInvoker();
        }
        this.invokingHelper = this.createInvokingHelper();
        this.restriction = this.createRestriction();
    }

    protected Serializer createSerializer() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (this.serializerClass != null) {
            return this.serializerClass.newInstance();
        }
        if (this.serializerClassName != null) {
            ClassLoader classLoader = this.serializerClassLoader;
            if (classLoader == null) {
                classLoader = this.getDefaultSerializerClassLoader();
            }
            return (Serializer)Class.forName(this.serializerClassName, true, classLoader).newInstance();
        }
        return this.createDefaultSerializer();
    }

    protected Serializer createDefaultSerializer() {
        return new XStreamSerializer();
    }

    protected ClassLoader getDefaultSerializerClassLoader() {
        return ClassLoaderUtils.getDefaultClassLoader(((Object)((Object)this)).getClass());
    }

    protected Invoker createDefaultInvoker() {
        return new DefaultInvoker();
    }

    protected ProxyInvokingHelper createInvokingHelper() {
        return new ProxyInvokingHelper();
    }

    protected InvocationRestriction createRestriction() {
        return new InvocationRestriction(this.getServiceInterface());
    }

    protected void invoke(InputStream is, OutputStream os) throws IOException {
        this.invokingHelper.invoke(this.getService(), is, os, this.serializer, this.invoker, this.restriction);
    }
}

