/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xremoting.core.commonshttpclient;

import com.googlecode.xremoting.core.commonshttpclient.ssl.AuthSSLProtocolSocketFactory;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class HttpClientBuilder {
    private String proxyHost;
    private int proxyPort = -1;
    private boolean authenticationPreemprive = true;
    private String basicAuthUsername;
    private String basicAuthPassword;
    private String basicAuthHost;
    private int basicAuthPort = -1;
    private Map<String, SslHostConfig> sslHostConfigs = new HashMap<String, SslHostConfig>();
    private String secureHost;
    private SslHostConfig sslHostConfig;
    private int connectionTimeout = 10000;
    private int soTimeout = 10000;
    private long connectionManagerTimeout = 10000L;

    public static HttpClientBuilder create() {
        return new HttpClientBuilder();
    }

    public HttpClientBuilder proxyHost(String host) {
        this.proxyHost = host;
        return this;
    }

    public HttpClientBuilder proxyPort(int port) {
        this.proxyPort = port;
        return this;
    }

    public HttpClientBuilder authPreemprive(boolean pre) {
        this.authenticationPreemprive = pre;
        return this;
    }

    public HttpClientBuilder basicAuth(String username, String password) {
        this.basicAuthUsername = username;
        this.basicAuthPassword = password;
        return this;
    }

    public HttpClientBuilder basicAuthHost(String host) {
        this.basicAuthHost = host;
        return this;
    }

    public HttpClientBuilder basicAuthPort(int port) {
        this.basicAuthPort = port;
        return this;
    }

    public HttpClientBuilder ssl(String host) {
        if (this.sslHostConfig != null) {
            this.sslHostConfigs.put(this.secureHost, this.sslHostConfig);
        }
        this.secureHost = host;
        this.sslHostConfig = new SslHostConfig();
        return this;
    }

    public HttpClientBuilder trustKeyStore(URL url, String password) {
        if (this.sslHostConfig == null) {
            throw new IllegalStateException("ssl(String) must be called before this");
        }
        this.sslHostConfig.trustKeyStoreUrl = url;
        this.sslHostConfig.trustKeyStorePassword = password;
        return this;
    }

    public HttpClientBuilder keyStore(URL url, String password) {
        if (this.sslHostConfig == null) {
            throw new IllegalStateException("ssl(String) must be called before this");
        }
        this.sslHostConfig.keyStoreUrl = url;
        this.sslHostConfig.keyStorePassword = password;
        return this;
    }

    public HttpClientBuilder secureSchema(String schema) {
        if (this.sslHostConfig == null) {
            throw new IllegalStateException("ssl(String) must be called before this");
        }
        this.sslHostConfig.secureSchema = schema;
        return this;
    }

    public HttpClientBuilder securePort(int port) {
        if (this.sslHostConfig == null) {
            throw new IllegalStateException("ssl(String) must be called before this");
        }
        this.sslHostConfig.securePort = port;
        return this;
    }

    public HttpClientBuilder timeouts(int connectionTimeout, int soTimeout, long connectionManagerTimeout) {
        this.connectionTimeout = connectionTimeout;
        this.soTimeout = soTimeout;
        this.connectionManagerTimeout = connectionManagerTimeout;
        return this;
    }

    public HttpClient build() {
        HttpClient httpClient = new HttpClient();
        if (this.proxyHost != null) {
            ProxyHost h = this.proxyPort == -1 ? new ProxyHost(this.proxyHost) : new ProxyHost(this.proxyHost, this.proxyPort);
            httpClient.getHostConfiguration().setProxyHost(h);
        }
        if (this.basicAuthUsername != null) {
            httpClient.getParams().setAuthenticationPreemptive(this.authenticationPreemprive);
            AuthScope authscope = new AuthScope(this.basicAuthHost == null ? AuthScope.ANY_HOST : this.basicAuthHost, this.basicAuthPort == -1 ? -1 : this.basicAuthPort);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.basicAuthUsername, this.basicAuthPassword);
            httpClient.getState().setCredentials(authscope, (Credentials)credentials);
        }
        if (this.sslHostConfig != null) {
            this.sslHostConfigs.put(this.secureHost, this.sslHostConfig);
        }
        for (Map.Entry<String, SslHostConfig> entry : this.sslHostConfigs.entrySet()) {
            String host = entry.getKey();
            SslHostConfig config = entry.getValue();
            AuthSSLProtocolSocketFactory factory = new AuthSSLProtocolSocketFactory(config.keyStoreUrl, config.keyStorePassword, config.trustKeyStoreUrl, config.trustKeyStorePassword);
            Protocol protocol = this.createProtocol((ProtocolSocketFactory)factory, config);
            httpClient.getHostConfiguration().setHost(host, config.securePort, protocol);
        }
        httpClient.getParams().setSoTimeout(this.soTimeout);
        httpClient.getParams().setConnectionManagerTimeout(this.connectionManagerTimeout);
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(this.connectionTimeout);
        return httpClient;
    }

    private Protocol createProtocol(ProtocolSocketFactory factory, SslHostConfig config) {
        return new Protocol(config.secureSchema, factory, config.securePort);
    }

    private static class SslHostConfig {
        public URL trustKeyStoreUrl;
        public URL keyStoreUrl;
        public String trustKeyStorePassword;
        public String keyStorePassword;
        public String secureSchema = "https";
        public int securePort = 443;

        private SslHostConfig() {
        }
    }
}

